/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.category;

import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.category.CategoryConfigurer;
import de.danielbechler.diff.category.CategoryResolver;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.diff.path.NodePath;
import de.danielbechler.diff.path.NodePathValueHolder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryService
implements CategoryConfigurer,
CategoryResolver {
    private final NodePathValueHolder<String[]> nodePathCategories = NodePathValueHolder.of(String[].class);
    private final Map<Class<?>, String[]> typeCategories = new HashMap();
    private final ObjectDifferBuilder objectDifferBuilder;

    public CategoryService(ObjectDifferBuilder objectDifferBuilder) {
        this.objectDifferBuilder = objectDifferBuilder;
    }

    @Override
    public Set<String> resolveCategories(DiffNode node) {
        TreeSet<String> categories = new TreeSet<String>();
        categories.addAll(this.categoriesFromNodePathConfiguration(node));
        categories.addAll(this.categoriesFromTypeConfiguration(node));
        categories.addAll(CategoryService.categoriesFromNode(node));
        return categories;
    }

    private Collection<String> categoriesFromNodePathConfiguration(DiffNode node) {
        HashSet<String> allCategories = new HashSet<String>();
        List<String[]> accumulatedValues = this.nodePathCategories.accumulatedValuesForNodePath(node.getPath());
        for (String[] categoriesForElement : accumulatedValues) {
            allCategories.addAll(Arrays.asList(categoriesForElement));
        }
        return allCategories;
    }

    private Collection<String> categoriesFromTypeConfiguration(DiffNode node) {
        String[] categories;
        Class<?> nodeType = node.getValueType();
        if (nodeType != null && (categories = this.typeCategories.get(nodeType)) != null) {
            return Arrays.asList(categories);
        }
        return Collections.emptySet();
    }

    private static Collection<String> categoriesFromNode(DiffNode node) {
        return node.getCategories();
    }

    @Override
    public CategoryConfigurer.Of ofNode(final NodePath nodePath) {
        return new CategoryConfigurer.Of(){

            public CategoryConfigurer toBe(String ... categories) {
                CategoryService.this.nodePathCategories.put(nodePath, categories);
                return CategoryService.this;
            }
        };
    }

    @Override
    public CategoryConfigurer.Of ofType(final Class<?> type) {
        return new CategoryConfigurer.Of(){

            public CategoryConfigurer toBe(String ... categories) {
                CategoryService.this.typeCategories.put(type, categories);
                return CategoryService.this;
            }
        };
    }

    @Override
    public ObjectDifferBuilder and() {
        return this.objectDifferBuilder;
    }
}

