/*
 * Decompiled with CFR 0.152.
 */
package spaceport.computer.memory.physical;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import groovy.json.JsonBuilder;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.eclipse.jetty.util.URIUtil;
import spaceport.Spaceport;
import spaceport.bridge.Command;
import spaceport.communications.http.HTTP;
import spaceport.computer.memory.physical.Document;
import spaceport.computer.memory.physical.Operation;
import spaceport.computer.memory.physical.View;
import spaceport.computer.memory.virtual.Cargo;
import spaceport.computer.memory.virtual.CargoSerializer;

public class CouchHandler
implements GroovyObject {
    private final ObjectMapper objectMapper;
    private String address;
    private String cookie;
    private String storedUsername;
    private String storedPassword;
    private long sessionExpiryTime;
    private Map<String, String> sequenceTracker;
    private static Object cachedDocuments;
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public CouchHandler(String address, String user, String pass) {
        MetaClass metaClass;
        Map map;
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        int n = 0;
        this.sessionExpiryTime = n;
        this.sequenceTracker = map = ScriptBytecodeAdapter.createMap(new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callConstructor(ObjectMapper.class);
        this.objectMapper = (ObjectMapper)ScriptBytecodeAdapter.castToType(object, ObjectMapper.class);
        callSiteArray[1].call(this.objectMapper, callSiteArray[2].callGetProperty(DeserializationFeature.class), false);
        callSiteArray[3].call(this.objectMapper, callSiteArray[4].callGetProperty(SerializationFeature.class), false);
        SimpleModule module = (SimpleModule)ScriptBytecodeAdapter.castToType(callSiteArray[5].callConstructor(SimpleModule.class), SimpleModule.class);
        callSiteArray[6].call(module, Cargo.class, callSiteArray[7].callConstructor(CargoSerializer.class));
        callSiteArray[8].call((Object)this.objectMapper, module);
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[9].callCurrent((GroovyObject)this, address);
            this.address = ShortTypeHandling.castToString(object2);
        } else {
            String string;
            this.address = string = this.normalizeAddress(address);
        }
        if (!BytecodeInterface8.isOrigZ() || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual(user, null) && ScriptBytecodeAdapter.compareNotEqual(pass, null)) {
                callSiteArray[10].callCurrent(this, user, pass);
            } else {
                callSiteArray[11].callCurrent(this);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual(user, null) && ScriptBytecodeAdapter.compareNotEqual(pass, null)) {
            this.authenticate(user, pass);
        } else {
            this.authenticate();
        }
    }

    public CouchHandler(String address) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        this(address, null, null);
    }

    private String normalizeAddress(String addr) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual(addr, null)) {
            throw (Throwable)callSiteArray[12].callConstructor(IllegalArgumentException.class, "Address cannot be null");
        }
        String normalized = addr;
        if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[13].call((Object)normalized, "/"))) {
            normalized = ShortTypeHandling.castToString(callSiteArray[14].call((Object)normalized, "/"));
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[15].call(callSiteArray[16].call(normalized), "http://")) && !DefaultTypeTransformation.booleanUnbox(callSiteArray[17].call(callSiteArray[18].call(normalized), "https://"))) {
                normalized = ShortTypeHandling.castToString(callSiteArray[19].call((Object)"http://", normalized));
            }
        } else if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[20].call(callSiteArray[21].call(normalized), "http://")) && !DefaultTypeTransformation.booleanUnbox(callSiteArray[22].call(callSiteArray[23].call(normalized), "https://"))) {
            normalized = ShortTypeHandling.castToString(callSiteArray[24].call((Object)"http://", normalized));
        }
        return normalized;
    }

    public void authenticate() {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        callSiteArray[25].callCurrent(this, callSiteArray[26].callGetProperty(callSiteArray[27].callGetProperty(callSiteArray[28].callGetProperty(callSiteArray[29].callGetProperty(Spaceport.class)))), callSiteArray[30].callGetProperty(callSiteArray[31].callGetProperty(callSiteArray[32].callGetProperty(callSiteArray[33].callGetProperty(Spaceport.class)))));
    }

    public void authenticate(String user, String pass) {
        Object response;
        CallSite[] callSiteArray;
        block17: {
            String string;
            String string2;
            callSiteArray = CouchHandler.$getCallSiteArray();
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual(user, null) || ScriptBytecodeAdapter.compareEqual(user, "")) {
                    user = ShortTypeHandling.castToString(callSiteArray[34].call(Command.class, "Enter COUCHDB username: "));
                }
            } else if (ScriptBytecodeAdapter.compareEqual(user, null) || ScriptBytecodeAdapter.compareEqual(user, "")) {
                user = ShortTypeHandling.castToString(callSiteArray[35].call(Command.class, "Enter COUCHDB username: "));
            }
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (!DefaultTypeTransformation.booleanUnbox(pass) || ScriptBytecodeAdapter.compareEqual(pass, "")) {
                    pass = ShortTypeHandling.castToString(callSiteArray[36].call(Command.class, callSiteArray[37].call(callSiteArray[38].call((Object)"Enter password for COUCHDB user '", user), "': ")));
                }
            } else if (!DefaultTypeTransformation.booleanUnbox(pass) || ScriptBytecodeAdapter.compareEqual(pass, "")) {
                pass = ShortTypeHandling.castToString(callSiteArray[39].call(Command.class, callSiteArray[40].call(callSiteArray[41].call((Object)"Enter password for COUCHDB user '", user), "': ")));
            }
            this.storedUsername = string2 = user;
            this.storedPassword = string = pass;
            Object url = callSiteArray[42].call(URIUtil.class, callSiteArray[43].call((Object)this.address, "_session"));
            response = callSiteArray[44].call(HTTP.class, url, ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Content-Type", "application/json"}), "body", callSiteArray[45].call(callSiteArray[46].callConstructor(JsonBuilder.class, ScriptBytecodeAdapter.createMap(new Object[]{"name", user, "password", pass})))}));
            if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[47].callGetProperty(response))) break block17;
            throw (Throwable)callSiteArray[48].callConstructor(Exception.class);
        }
        try {
            Object setCookieHeader = callSiteArray[49].call(callSiteArray[50].callGetProperty(response), "Set-Cookie");
            String cookieHeaderStr = ShortTypeHandling.castToString(setCookieHeader);
            if (setCookieHeader instanceof List) {
                public final class _authenticate_closure1
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _authenticate_closure1(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _authenticate_closure1.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _authenticate_closure1.$getCallSiteArray();
                        return callSiteArray[0].call(it, "AuthSession");
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _authenticate_closure1.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _authenticate_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "contains";
                        return new CallSiteArray(_authenticate_closure1.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _authenticate_closure1.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                cookieHeaderStr = ShortTypeHandling.castToString(callSiteArray[51].call(setCookieHeader, new _authenticate_closure1(this, this)));
            }
            Object object = callSiteArray[52].call(callSiteArray[53].call(callSiteArray[54].call(callSiteArray[55].call((Object)cookieHeaderStr, "="), 1), ";"), 0);
            this.cookie = ShortTypeHandling.castToString(object);
            if (!DefaultTypeTransformation.booleanUnbox(this.cookie)) {
                throw (Throwable)callSiteArray[56].callConstructor(Exception.class, "No AuthSession cookie from CouchDB. Invalid username or password?");
            }
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[57].callCurrent((GroovyObject)this, cookieHeaderStr);
            } else {
                this.parseSessionExpiry(cookieHeaderStr);
            }
            callSiteArray[58].call(Command.class, callSiteArray[59].call(callSiteArray[60].call((Object)"[GREEN]Successfully authenticated with CouchDB. Session expires at: ", callSiteArray[61].callConstructor(Date.class, this.sessionExpiryTime)), "[RESET]"));
        }
        catch (Exception e) {
            callSiteArray[62].call(Command.class, "Failed to authenticate.");
            callSiteArray[63].call(Command.class, callSiteArray[64].call((Object)"Message: ", callSiteArray[65].callGetProperty(e)));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseSessionExpiry(String setCookieHeader) {
        block10: {
            block9: {
                var2_2 = CouchHandler.$getCallSiteArray();
                maxAgeMatch = ScriptBytecodeAdapter.findRegex(setCookieHeader, "Max-Age=(\\d+)");
                if (!DefaultTypeTransformation.booleanUnbox(maxAgeMatch)) ** GOTO lbl24
                maxAge = DefaultTypeTransformation.longUnbox(var2_2[66].call(Long.class, ScriptBytecodeAdapter.createPojoWrapper((String)ScriptBytecodeAdapter.asType(var2_2[67].call(var2_2[68].call((Object)maxAgeMatch, 0), 1), String.class), String.class)));
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigL() || CouchHandler.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    var6_5 = var2_2[69].call(var2_2[70].call(System.class), DefaultTypeTransformation.longUnbox(var2_2[71].call(var2_2[72].call((Object)maxAge, 1000), CouchHandler.$const$0)));
                    this.sessionExpiryTime = DefaultTypeTransformation.longUnbox(var6_5);
                    break block9;
                }
                var7_6 = var2_2[73].call(var2_2[74].call(System.class), DefaultTypeTransformation.longUnbox(var2_2[75].call((Object)(maxAge * (long)1000), CouchHandler.$const$0)));
                this.sessionExpiryTime = DefaultTypeTransformation.longUnbox(var7_6);
            }
            return;
lbl24:
            // 1 sources

            expiresMatch = ScriptBytecodeAdapter.findRegex(setCookieHeader, "Expires=([^;]+)");
            if (!DefaultTypeTransformation.booleanUnbox(expiresMatch)) ** GOTO lbl44
            expiresStr = ShortTypeHandling.castToString(var2_2[76].call((String)ScriptBytecodeAdapter.asType(var2_2[77].call(var2_2[78].call((Object)expiresMatch, 0), 1), String.class)));
            dateFormat = var2_2[79].callConstructor(SimpleDateFormat.class, "EEE, dd-MMM-yyyy HH:mm:ss zzz", var2_2[80].callGetProperty(Locale.class));
            expiryDate = (Date)ScriptBytecodeAdapter.castToType(var2_2[81].call(dateFormat, expiresStr), Date.class);
            timeUntilExpiry = DefaultTypeTransformation.longUnbox(var2_2[82].call(var2_2[83].callGetProperty(expiryDate), var2_2[84].call(System.class)));
            var14_12 = var2_2[85].call(var2_2[86].call(System.class), DefaultTypeTransformation.longUnbox(var2_2[87].call((Object)timeUntilExpiry, CouchHandler.$const$0)));
            this.sessionExpiryTime = DefaultTypeTransformation.longUnbox(var14_12);
            try {
                return;
lbl44:
                // 1 sources

                var2_2[88].call(Command.class, "[YELLOW]Could not parse session expiry, defaulting to 10 minutes[RESET]");
                if (!BytecodeInterface8.isOrigInt() || CouchHandler.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    var15_13 = var2_2[89].call(var2_2[90].call(System.class), var2_2[91].call(var2_2[92].call((Object)10, 60), 1000));
                    this.sessionExpiryTime = DefaultTypeTransformation.longUnbox(var15_13);
                    break block10;
                }
                var16_14 = var2_2[93].call(var2_2[94].call(System.class), 10 * 60 * 1000);
                this.sessionExpiryTime = DefaultTypeTransformation.longUnbox(var16_14);
            }
            catch (Exception e) {
                var2_2[95].call(Command.class, var2_2[96].call(var2_2[97].call((Object)"[YELLOW]Error parsing session expiry: ", var2_2[98].callGetProperty(e)), ", defaulting to 10 minutes[RESET]"));
                if (!BytecodeInterface8.isOrigInt() || CouchHandler.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    var18_16 = var2_2[99].call(var2_2[100].call(System.class), var2_2[101].call(var2_2[102].call((Object)10, 60), 1000));
                    this.sessionExpiryTime = DefaultTypeTransformation.longUnbox(var18_16);
                    break block10;
                }
                var19_17 = var2_2[103].call(var2_2[104].call(System.class), 10 * 60 * 1000);
                this.sessionExpiryTime = DefaultTypeTransformation.longUnbox(var19_17);
            }
        }
    }

    private boolean ensureValidSession() {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareGreaterThanEqual(callSiteArray[105].call(System.class), this.sessionExpiryTime)) {
            callSiteArray[106].call(Command.class, "[YELLOW]Session expired or about to expire, refreshing...[RESET]");
            if (DefaultTypeTransformation.booleanUnbox(this.storedUsername) && DefaultTypeTransformation.booleanUnbox(this.storedPassword)) {
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    callSiteArray[107].callCurrent(this, this.storedUsername, this.storedPassword);
                } else {
                    this.authenticate(this.storedUsername, this.storedPassword);
                }
                return ScriptBytecodeAdapter.compareNotEqual(this.cookie, null);
            }
            callSiteArray[108].call(Command.class, "Cannot refresh session: no stored credentials");
            return false;
        }
        return true;
    }

    public Operation createDatabase(String id) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[109].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object url = callSiteArray[110].call(URIUtil.class, callSiteArray[111].call((Object)this.address, id));
        Object returned = callSiteArray[112].callGetProperty(callSiteArray[113].call(HTTP.class, url, ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[114].call((Object)"AuthSession=", this.cookie)}), "body", callSiteArray[115].call(callSiteArray[116].callConstructor(JsonBuilder.class, ScriptBytecodeAdapter.createMap(new Object[0])))})));
        return (Operation)ScriptBytecodeAdapter.castToType(callSiteArray[117].call(this.objectMapper, returned, Operation.class), Operation.class);
    }

    public Operation createDatabaseIfNotExists(String id) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[118].callCurrent(this);
            if (DefaultTypeTransformation.booleanUnbox(callSiteArray[119].callCurrent((GroovyObject)this, id))) {
                return (Operation)ScriptBytecodeAdapter.castToType(callSiteArray[120].call(Operation.class, "Database already exists, continuing."), Operation.class);
            }
            return (Operation)ScriptBytecodeAdapter.castToType(callSiteArray[121].callCurrent((GroovyObject)this, id), Operation.class);
        }
        this.ensureValidSession();
        if (this.containsDatabase(id)) {
            return (Operation)ScriptBytecodeAdapter.castToType(callSiteArray[122].call(Operation.class, "Database already exists, continuing."), Operation.class);
        }
        return this.createDatabase(id);
    }

    public List<String> getAllDatabases() {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[123].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object returned = callSiteArray[124].callGetProperty(callSiteArray[125].call(HTTP.class, ScriptBytecodeAdapter.createPojoWrapper((String)ScriptBytecodeAdapter.asType(callSiteArray[126].call((Object)this.address, "_all_dbs"), String.class), String.class), ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[127].call((Object)"AuthSession=", this.cookie)})})));
        return (List)ScriptBytecodeAdapter.asType(callSiteArray[128].call(callSiteArray[129].callConstructor(JsonSlurper.class), returned), List.class);
    }

    public Operation deleteDatabase(String id) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[130].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object url = callSiteArray[131].call(URIUtil.class, callSiteArray[132].call((Object)this.address, id));
        Object returned = callSiteArray[133].callGetProperty(callSiteArray[134].call(HTTP.class, url, ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[135].call((Object)"AuthSession=", this.cookie)})})));
        return (Operation)ScriptBytecodeAdapter.castToType(callSiteArray[136].call(this.objectMapper, returned, Operation.class), Operation.class);
    }

    public boolean containsDatabase(String id) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[137].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object returned = callSiteArray[138].callGetProperty(callSiteArray[139].call(HTTP.class, ScriptBytecodeAdapter.createPojoWrapper((String)ScriptBytecodeAdapter.asType(callSiteArray[140].call((Object)this.address, "_all_dbs"), String.class), String.class), ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[141].call((Object)"AuthSession=", this.cookie)})})));
        return DefaultTypeTransformation.booleanUnbox(callSiteArray[142].call((Object)((List)ScriptBytecodeAdapter.asType(callSiteArray[143].call(callSiteArray[144].callConstructor(JsonSlurper.class), returned), List.class)), id));
    }

    public Map getChanges(String database, Map parameters) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[145].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        public final class _getChanges_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getChanges_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getChanges_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getChanges_closure2.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareNotEqual(callSiteArray[0].callGetProperty(it), "no_store");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _getChanges_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _getChanges_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "key";
                return new CallSiteArray(_getChanges_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getChanges_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Map couchParams = (Map)ScriptBytecodeAdapter.castToType(callSiteArray[146].call((Object)parameters, new _getChanges_closure2(this, this)), Map.class);
        Object url = callSiteArray[147].call(callSiteArray[148].call((Object)this.address, database), "/_changes");
        Object response = callSiteArray[149].callGetProperty(callSiteArray[150].call(HTTP.class, ScriptBytecodeAdapter.createPojoWrapper((String)ScriptBytecodeAdapter.asType(url, String.class), String.class), ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[151].call((Object)"AuthSession=", this.cookie)}), "queryParams", couchParams})));
        Map map = (Map)ScriptBytecodeAdapter.asType(callSiteArray[152].call(callSiteArray[153].callConstructor(JsonSlurper.class), response), Map.class);
        try {
            return map;
        }
        catch (Exception e) {
            callSiteArray[154].call(Command.class, new GStringImpl(new Object[]{database}, new String[]{"Failed to fetch changes for database: ", ""}));
            callSiteArray[155].call(e);
            Map map2 = (Map)ScriptBytecodeAdapter.castToType(null, Map.class);
            return map2;
        }
    }

    public Map getNewChanges(String database, Map parameters) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        boolean noStore = DefaultTypeTransformation.booleanUnbox(callSiteArray[156].call(parameters, "no_store", false));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[157].call((Object)parameters, "since"))) {
                if (DefaultTypeTransformation.booleanUnbox(callSiteArray[158].call(this.sequenceTracker, database))) {
                    Object object = callSiteArray[159].call(this.sequenceTracker, database);
                    callSiteArray[160].call(parameters, "since", object);
                } else {
                    Object object = callSiteArray[161].callCurrent((GroovyObject)this, database);
                    callSiteArray[162].call(parameters, "since", object);
                }
            }
        } else if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[163].call((Object)parameters, "since"))) {
            if (DefaultTypeTransformation.booleanUnbox(callSiteArray[164].call(this.sequenceTracker, database))) {
                Object object = callSiteArray[165].call(this.sequenceTracker, database);
                callSiteArray[166].call(parameters, "since", object);
            } else {
                String string = this.accessCheckpoint(database);
                callSiteArray[167].call(parameters, "since", string);
            }
        }
        Map response = (Map)ScriptBytecodeAdapter.castToType(callSiteArray[168].callCurrent(this, database, parameters), Map.class);
        if (DefaultTypeTransformation.booleanUnbox(response) && DefaultTypeTransformation.booleanUnbox(callSiteArray[169].callGetProperty(response))) {
            String newSeq = ShortTypeHandling.castToString(callSiteArray[170].callGetProperty(response));
            String string = newSeq;
            callSiteArray[171].call(this.sequenceTracker, database, string);
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (!noStore) {
                    callSiteArray[172].callCurrent(this, database, newSeq);
                }
            } else if (!noStore) {
                this.accessCheckpoint(database, newSeq);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String accessCheckpoint(String database, String newSeq) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        String docId = ShortTypeHandling.castToString(new GStringImpl(new Object[]{database}, new String[]{"checkpoint_", ""}));
        String checkpointDb = "_spaceport";
        try {
            if (!__$stMC && !BytecodeInterface8.disabledStandardMetaClass()) {
                this.ensureValidSession();
            } else {
                callSiteArray[173].callCurrent(this);
            }
            if (!__$stMC && !BytecodeInterface8.disabledStandardMetaClass()) {
                this.createDatabaseIfNotExists(checkpointDb);
            } else {
                callSiteArray[174].callCurrent((GroovyObject)this, checkpointDb);
            }
            Object checkDoc = callSiteArray[175].callCurrent(this, docId, checkpointDb, Map.class, true);
            if (!DefaultTypeTransformation.booleanUnbox(newSeq)) Object object;
            return ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(object = callSiteArray[183].callGetPropertySafe(checkDoc)) ? object : "0");
            if (DefaultTypeTransformation.booleanUnbox(checkDoc)) {
                String string = newSeq;
                ScriptBytecodeAdapter.setProperty(string, null, checkDoc, "last_seq");
                callSiteArray[176].callCurrent(this, checkDoc, checkpointDb);
                return newSeq;
            } else {
                Map body = ScriptBytecodeAdapter.createMap(new Object[]{"_id", docId, "last_seq", newSeq, "type", "checkpoint"});
                callSiteArray[177].call(HTTP.class, callSiteArray[178].call(callSiteArray[179].call(callSiteArray[180].call((Object)this.address, checkpointDb), "/"), docId), ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[181].call((Object)"AuthSession=", this.cookie)}), "body", callSiteArray[182].call((Object)this.objectMapper, body)}));
            }
            return newSeq;
        }
        catch (Exception e) {
            callSiteArray[184].call(Command.class, new GStringImpl(new Object[]{database, callSiteArray[185].callGetProperty(e)}, new String[]{"[YELLOW]Checkpoint fallback for ", ": ", "[RESET]"}));
            Object object = callSiteArray[186].call(this.sequenceTracker, database);
            return ShortTypeHandling.castToString(DefaultTypeTransformation.booleanUnbox(object) ? object : "0");
        }
    }

    /*
     * Unable to fully structure code
     */
    public <T> T getDoc(String id, String database, Class type, Object ignoreCache) {
        var5_5 = CouchHandler.$getCallSiteArray();
        if (BytecodeInterface8.isOrigZ() == false || CouchHandler.__$stMC != false || BytecodeInterface8.disabledStandardMetaClass() != false ? (ScriptBytecodeAdapter.compareEqual(database, null) != false || ScriptBytecodeAdapter.compareEqual(id, null) != false) != false : (ScriptBytecodeAdapter.compareEqual(database, null) != false || ScriptBytecodeAdapter.compareEqual(id, null) != false) != false) {
            return null;
        }
        if (!BytecodeInterface8.isOrigZ() || CouchHandler.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if ((DefaultTypeTransformation.booleanUnbox(ignoreCache) == false != false && DefaultTypeTransformation.booleanUnbox(var5_5[187].call(CouchHandler.cachedDocuments, var5_5[188].call(var5_5[189].call((Object)id, "/"), database))) != false) != false && (ScriptBytecodeAdapter.compareEqual(var5_5[190].call(var5_5[191].call(CouchHandler.cachedDocuments, var5_5[192].call(var5_5[193].call((Object)id, "/"), database))), type) != false || ScriptBytecodeAdapter.compareNotEqual(var5_5[194].call(var5_5[195].call(CouchHandler.cachedDocuments, var5_5[196].call(var5_5[197].call((Object)id, "/"), database))), Document.class) != false) != false) {
                var5_5[198].call(Command.class, var5_5[199].call(var5_5[200].call(var5_5[201].call(var5_5[202].call((Object)"[MAGENTA]Returned cached document ", id), "/"), database), "[RESET]"));
                return (T)var5_5[203].call(CouchHandler.cachedDocuments, var5_5[204].call(var5_5[205].call((Object)id, "/"), database));
            }
        } else if ((DefaultTypeTransformation.booleanUnbox(ignoreCache) == false != false && DefaultTypeTransformation.booleanUnbox(var5_5[206].call(CouchHandler.cachedDocuments, var5_5[207].call(var5_5[208].call((Object)id, "/"), database))) != false) != false && (ScriptBytecodeAdapter.compareEqual(var5_5[209].call(var5_5[210].call(CouchHandler.cachedDocuments, var5_5[211].call(var5_5[212].call((Object)id, "/"), database))), type) != false || ScriptBytecodeAdapter.compareNotEqual(var5_5[213].call(var5_5[214].call(CouchHandler.cachedDocuments, var5_5[215].call(var5_5[216].call((Object)id, "/"), database))), Document.class) != false) != false) {
            var5_5[217].call(Command.class, var5_5[218].call(var5_5[219].call(var5_5[220].call(var5_5[221].call((Object)"[MAGENTA]Returned cached document ", id), "/"), database), "[RESET]"));
            return (T)var5_5[222].call(CouchHandler.cachedDocuments, var5_5[223].call(var5_5[224].call((Object)id, "/"), database));
        }
        if (CouchHandler.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            var5_5[225].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        returned = var5_5[226].callGetProperty(var5_5[227].call(HTTP.class, ScriptBytecodeAdapter.createPojoWrapper((String)ScriptBytecodeAdapter.asType(var5_5[228].call(var5_5[229].call(var5_5[230].call((Object)this.address, database), "/"), id), String.class), String.class), ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", var5_5[231].call((Object)"AuthSession=", this.cookie)})})));
        doc = var5_5[232].call(this.objectMapper, returned, type);
        if (!ScriptBytecodeAdapter.compareEqual(var5_5[233].callGetProperty(doc), null)) ** GOTO lbl32
        var8_8 = null;
        return var8_8;
lbl32:
        // 1 sources

        var9_9 = database;
        ScriptBytecodeAdapter.setProperty(var9_9, null, doc, "database");
        if (DefaultTypeTransformation.booleanUnbox(ignoreCache) == false) {
            var5_5[234].call(CouchHandler.cachedDocuments, var5_5[235].call(var5_5[236].call((Object)id, "/"), database), ScriptBytecodeAdapter.createPojoWrapper(doc, Object.class));
            var5_5[237].call(Command.class, var5_5[238].call(var5_5[239].call(var5_5[240].call(var5_5[241].call((Object)"[MAGENTA]Added ", id), "/"), database), " to cache.[RESET]"));
        }
        var10_10 = doc;
        try {
            return (T)var10_10;
        }
        catch (Exception e) {
            var5_5[242].call(e);
            var12_12 = null;
            return var12_12;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Document getDocRevision(String id, String database, Object rev) {
        var4_4 = CouchHandler.$getCallSiteArray();
        if (BytecodeInterface8.isOrigZ() == false || CouchHandler.__$stMC != false || BytecodeInterface8.disabledStandardMetaClass() != false ? (ScriptBytecodeAdapter.compareEqual(database, null) != false || ScriptBytecodeAdapter.compareEqual(id, null) != false) != false : (ScriptBytecodeAdapter.compareEqual(database, null) != false || ScriptBytecodeAdapter.compareEqual(id, null) != false) != false) {
            return (Document)ScriptBytecodeAdapter.castToType(null, Document.class);
        }
        if (CouchHandler.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            var4_4[243].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        if (!ScriptBytecodeAdapter.compareEqual(rev, null)) ** GOTO lbl18
        var5_5 = (Document)ScriptBytecodeAdapter.castToType(null, Document.class);
        return var5_5;
lbl18:
        // 1 sources

        returned = var4_4[244].callGetProperty(var4_4[245].call(HTTP.class, ScriptBytecodeAdapter.createPojoWrapper((String)ScriptBytecodeAdapter.asType(var4_4[246].call(var4_4[247].call(var4_4[248].call((Object)this.address, database), "/"), id), String.class), String.class), ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", var4_4[249].call((Object)"AuthSession=", this.cookie)}), "queryParams", ScriptBytecodeAdapter.createMap(new Object[]{"rev", rev})})));
        doc = var4_4[250].call(this.objectMapper, returned, Document.class);
        if (!ScriptBytecodeAdapter.compareEqual(var4_4[251].callGetProperty(doc), null)) ** GOTO lbl28
        var8_8 = (Document)ScriptBytecodeAdapter.castToType(null, Document.class);
        return var8_8;
lbl28:
        // 1 sources

        var9_9 = database;
        ScriptBytecodeAdapter.setProperty(var9_9, null, doc, "database");
        var10_10 = (Document)ScriptBytecodeAdapter.castToType(doc, Document.class);
        try {
            return var10_10;
        }
        catch (Exception e) {
            var4_4[252].call(e);
            var12_12 = (Document)ScriptBytecodeAdapter.castToType(null, Document.class);
            return var12_12;
        }
    }

    public Map getDocAttachment(String attachment, String id, String database, OutputStream o) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[253].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object url = callSiteArray[254].call(URIUtil.class, callSiteArray[255].call(callSiteArray[256].call(callSiteArray[257].call(callSiteArray[258].call(callSiteArray[259].call((Object)this.address, database), "/"), id), "/"), attachment));
        CloseableHttpClient httpClient = (CloseableHttpClient)ScriptBytecodeAdapter.castToType(callSiteArray[260].call(HttpClients.class), CloseableHttpClient.class);
        HttpGet httpGet = (HttpGet)ScriptBytecodeAdapter.castToType(callSiteArray[261].callConstructor(HttpGet.class, url), HttpGet.class);
        callSiteArray[262].call(httpGet, "Cookie", callSiteArray[263].call((Object)"AuthSession=", this.cookie));
        CloseableHttpResponse response = null;
        Map returned = ScriptBytecodeAdapter.createMap(new Object[0]);
        try {
            try {
                response = (CloseableHttpResponse)ScriptBytecodeAdapter.castToType(callSiteArray[264].call((Object)httpClient, httpGet), CloseableHttpResponse.class);
                HttpEntity entity = (HttpEntity)ScriptBytecodeAdapter.castToType(callSiteArray[265].call(response), HttpEntity.class);
                returned = ScriptBytecodeAdapter.createMap(new Object[]{"content_type", callSiteArray[266].callGetProperty(callSiteArray[267].call(entity)), "content_length", callSiteArray[268].call(entity)});
                callSiteArray[269].call((Object)entity, o);
                callSiteArray[270].call(EntityUtils.class, entity);
            }
            catch (Exception e) {
                callSiteArray[271].call(e);
            }
        }
        catch (Throwable throwable) {
            if (ScriptBytecodeAdapter.compareNotEqual(response, null)) {
                try {
                    callSiteArray[274].call(response);
                }
                catch (IOException e) {
                    callSiteArray[275].call(e);
                }
            }
            throw throwable;
        }
        if (ScriptBytecodeAdapter.compareNotEqual(response, null)) {
            try {
                callSiteArray[272].call(response);
            }
            catch (IOException e) {
                callSiteArray[273].call(e);
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType(returned, Map.class);
    }

    public Operation addDoc(String id, String database) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[276].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object url = callSiteArray[277].call(callSiteArray[278].call(callSiteArray[279].call((Object)this.address, database), "/"), id);
        Object returned = callSiteArray[280].callGetProperty(callSiteArray[281].call(HTTP.class, url, ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[282].call((Object)"AuthSession=", this.cookie)}), "body", callSiteArray[283].call(callSiteArray[284].callConstructor(JsonBuilder.class, ScriptBytecodeAdapter.createMap(new Object[0])))})));
        return (Operation)ScriptBytecodeAdapter.castToType(callSiteArray[285].call(this.objectMapper, returned, Operation.class), Operation.class);
    }

    public Operation updateDoc(Object doc, String database) {
        Reference<Object> doc2 = new Reference<Object>(doc);
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[286].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        if (ScriptBytecodeAdapter.compareEqual(database, null)) {
            database = ShortTypeHandling.castToString(callSiteArray[287].callGetProperty(doc2.get()));
        }
        Object url = callSiteArray[288].call(callSiteArray[289].call(callSiteArray[290].call((Object)this.address, database), "/"), callSiteArray[291].callGetProperty(doc2.get()));
        Reference<List> properties = new Reference<List>(ScriptBytecodeAdapter.createList(new Object[]{"_id", "_rev", "type", "fields", "states", "cargo", "updates", "_attachments"}));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox(callSiteArray[292].call(doc2.get(), "customProperties")) && callSiteArray[293].callGetProperty(doc2.get()) instanceof List && ScriptBytecodeAdapter.compareGreaterThan(callSiteArray[294].call(callSiteArray[295].callGetProperty(doc2.get())), 0)) {
                callSiteArray[296].call(Command.class, callSiteArray[297].call((Object)"Added custom properties for update -> ", callSiteArray[298].callGetProperty(doc2.get())));
                callSiteArray[299].call((Object)properties.get(), callSiteArray[300].callGetProperty(doc2.get()));
            }
        } else if (DefaultTypeTransformation.booleanUnbox(callSiteArray[301].call(doc2.get(), "customProperties")) && callSiteArray[302].callGetProperty(doc2.get()) instanceof List && ScriptBytecodeAdapter.compareGreaterThan(callSiteArray[303].call(callSiteArray[304].callGetProperty(doc2.get())), 0)) {
            callSiteArray[305].call(Command.class, callSiteArray[306].call((Object)"Added custom properties for update -> ", callSiteArray[307].callGetProperty(doc2.get())));
            callSiteArray[308].call((Object)properties.get(), callSiteArray[309].callGetProperty(doc2.get()));
        }
        Reference<Map> filteredDoc = new Reference<Map>(ScriptBytecodeAdapter.createMap(new Object[0]));
        public final class _updateDoc_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference doc;
            private /* synthetic */ Reference filteredDoc;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateDoc_closure3(Object _outerInstance, Object _thisObject, Reference doc, Reference filteredDoc) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _updateDoc_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.doc = reference2 = doc;
                this.filteredDoc = reference = filteredDoc;
            }

            public Object doCall(Object property) {
                CallSite[] callSiteArray = _updateDoc_closure3.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox(callSiteArray[0].call(this.doc.get(), property))) {
                    Object object = callSiteArray[1].call(this.doc.get(), property);
                    callSiteArray[2].call(this.filteredDoc.get(), property, object);
                    return object;
                }
                return null;
            }

            @Generated
            public Object getDoc() {
                CallSite[] callSiteArray = _updateDoc_closure3.$getCallSiteArray();
                return this.doc.get();
            }

            @Generated
            public Object getFilteredDoc() {
                CallSite[] callSiteArray = _updateDoc_closure3.$getCallSiteArray();
                return this.filteredDoc.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _updateDoc_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "hasProperty";
                stringArray[1] = "getAt";
                stringArray[2] = "putAt";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _updateDoc_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateDoc_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateDoc_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[310].call((Object)properties.get(), new _updateDoc_closure3(this, this, doc2, filteredDoc));
        public final class _updateDoc_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference properties;
            private /* synthetic */ Reference filteredDoc;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateDoc_closure4(Object _outerInstance, Object _thisObject, Reference properties, Reference filteredDoc) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _updateDoc_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.properties = reference2 = properties;
                this.filteredDoc = reference = filteredDoc;
            }

            public Object doCall(Object property, Object value) {
                CallSite[] callSiteArray = _updateDoc_closure4.$getCallSiteArray();
                if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[0].call(this.properties.get(), property))) {
                    Object object = value;
                    callSiteArray[1].call(this.filteredDoc.get(), property, object);
                    return object;
                }
                return null;
            }

            @Generated
            public Object call(Object property, Object value) {
                CallSite[] callSiteArray = _updateDoc_closure4.$getCallSiteArray();
                return callSiteArray[2].callCurrent(this, property, value);
            }

            @Generated
            public Object getProperties() {
                CallSite[] callSiteArray = _updateDoc_closure4.$getCallSiteArray();
                return this.properties.get();
            }

            @Generated
            public Object getFilteredDoc() {
                CallSite[] callSiteArray = _updateDoc_closure4.$getCallSiteArray();
                return this.filteredDoc.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _updateDoc_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "contains";
                stringArray[1] = "putAt";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _updateDoc_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateDoc_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateDoc_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[311].call(callSiteArray[312].callGetProperty(doc2.get()), new _updateDoc_closure4(this, this, properties, filteredDoc));
        Object response = callSiteArray[313].callGetProperty(callSiteArray[314].call(HTTP.class, url, ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[315].call((Object)"AuthSession=", this.cookie)}), "body", callSiteArray[316].call((Object)this.objectMapper, filteredDoc.get())})));
        Object operation = callSiteArray[317].call(this.objectMapper, response, Operation.class);
        Operation operation2 = (Operation)ScriptBytecodeAdapter.castToType(operation, Operation.class);
        try {
            return operation2;
        }
        catch (Exception e) {
            callSiteArray[318].call(Command.class, callSiteArray[319].call((Object)"Failed to update document: ", callSiteArray[320].callGetProperty(e)));
            callSiteArray[321].call(e);
            Operation operation3 = (Operation)ScriptBytecodeAdapter.castToType(null, Operation.class);
            return operation3;
        }
    }

    public Operation removeDocAttachment(String doc, String database, String rev, String attachment) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[322].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object url = callSiteArray[323].call(callSiteArray[324].call(callSiteArray[325].call(callSiteArray[326].call(callSiteArray[327].call((Object)this.address, database), "/"), doc), "/"), attachment);
        Object returned = callSiteArray[328].callGetProperty(callSiteArray[329].call(HTTP.class, url, ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[330].call((Object)"AuthSession=", this.cookie)}), "queryParams", ScriptBytecodeAdapter.createMap(new Object[]{"rev", rev})})));
        Operation operation = (Operation)ScriptBytecodeAdapter.castToType(callSiteArray[331].call(this.objectMapper, returned, Operation.class), Operation.class);
        try {
            return operation;
        }
        catch (Exception e) {
            callSiteArray[332].call(Command.class, callSiteArray[333].call((Object)"Failed to remove attachment: ", callSiteArray[334].callGetProperty(e)));
            callSiteArray[335].call(e);
            Operation operation2 = (Operation)ScriptBytecodeAdapter.castToType(null, Operation.class);
            return operation2;
        }
    }

    public Operation removeDoc(Object doc, String database) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[336].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        if (ScriptBytecodeAdapter.compareEqual(database, null)) {
            database = ShortTypeHandling.castToString(callSiteArray[337].callGetProperty(doc));
        }
        Object url = callSiteArray[338].call(callSiteArray[339].call(callSiteArray[340].call((Object)this.address, database), "/"), callSiteArray[341].callGetProperty(doc));
        Object returned = null;
        try {
            callSiteArray[342].call(Command.class, callSiteArray[343].call(callSiteArray[344].call(callSiteArray[345].call(callSiteArray[346].call((Object)"[RED]Removing document ", callSiteArray[347].callGetProperty(doc)), " from database "), database), "[RESET]"));
            returned = callSiteArray[348].callGetProperty(callSiteArray[349].call(HTTP.class, url, ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[350].call((Object)"AuthSession=", this.cookie)}), "queryParams", ScriptBytecodeAdapter.createMap(new Object[]{"rev", callSiteArray[351].callGetProperty(doc)})})));
        }
        catch (Exception e) {
            callSiteArray[352].call(Command.class, callSiteArray[353].call((Object)"Failed to remove document: ", callSiteArray[354].callGetProperty(e)));
            callSiteArray[355].call(e);
            Operation operation = (Operation)ScriptBytecodeAdapter.castToType(null, Operation.class);
            return operation;
        }
        Operation operation = (Operation)ScriptBytecodeAdapter.castToType(callSiteArray[356].call(this.objectMapper, returned, Operation.class), Operation.class);
        if (ScriptBytecodeAdapter.compareEqual(callSiteArray[357].callGroovyObjectGetProperty(operation), true)) {
            Object object = callSiteArray[358].callGroovyObjectGetProperty(operation);
            ScriptBytecodeAdapter.setProperty(object, null, doc, "_rev");
        }
        return operation;
    }

    public View getView(String document_id, String view_id, String database, Map parameters) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[359].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        document_id = ShortTypeHandling.castToString(callSiteArray[360].callSafe(document_id, "_design/", ""));
        Object returned = callSiteArray[361].callGetProperty(callSiteArray[362].call(HTTP.class, ScriptBytecodeAdapter.createPojoWrapper((String)ScriptBytecodeAdapter.asType(callSiteArray[363].call(callSiteArray[364].call(callSiteArray[365].call(callSiteArray[366].call(callSiteArray[367].call((Object)this.address, database), "/_design/"), document_id), "/_view/"), view_id), String.class), String.class), ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[368].call((Object)"AuthSession=", this.cookie)}), "queryParams", parameters})));
        View view = (View)ScriptBytecodeAdapter.castToType(callSiteArray[369].call(callSiteArray[370].callConstructor(ObjectMapper.class), returned, View.class), View.class);
        String string = database;
        ScriptBytecodeAdapter.setGroovyObjectProperty(string, CouchHandler.class, view, "database");
        View view2 = view;
        try {
            return view2;
        }
        catch (Exception e) {
            callSiteArray[371].call(Command.class, callSiteArray[372].call(callSiteArray[373].call(callSiteArray[374].call(callSiteArray[375].call(callSiteArray[376].call(callSiteArray[377].call(callSiteArray[378].call(callSiteArray[379].call((Object)"Attempted to grab: ", this.address), database), "/_design/"), document_id), "/_view/"), view_id), "?"), parameters));
            callSiteArray[380].call(Command.class, returned);
            callSiteArray[381].call(e);
            View view3 = (View)ScriptBytecodeAdapter.castToType(null, View.class);
            return view3;
        }
    }

    public View getAll(String database, Map parameters) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[382].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object returned = callSiteArray[383].callGetProperty(callSiteArray[384].call(HTTP.class, ScriptBytecodeAdapter.createPojoWrapper((String)ScriptBytecodeAdapter.asType(callSiteArray[385].call(callSiteArray[386].call(callSiteArray[387].call(callSiteArray[388].call((Object)this.address, database), "/_all_docs"), "?"), parameters), String.class), String.class), ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[389].call((Object)"AuthSession=", this.cookie)}), "queryParams", parameters})));
        View view = (View)ScriptBytecodeAdapter.castToType(callSiteArray[390].call(callSiteArray[391].callConstructor(ObjectMapper.class), returned, View.class), View.class);
        String string = database;
        ScriptBytecodeAdapter.setGroovyObjectProperty(string, CouchHandler.class, view, "database");
        View view2 = view;
        try {
            return view2;
        }
        catch (Exception e) {
            View view3 = (View)ScriptBytecodeAdapter.castToType(null, View.class);
            return view3;
        }
    }

    @Generated
    public Map getChanges(String database) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        return this.getChanges(database, ScriptBytecodeAdapter.createMap(new Object[0]));
    }

    @Generated
    public Map getNewChanges(String database) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        return this.getNewChanges(database, ScriptBytecodeAdapter.createMap(new Object[0]));
    }

    @Generated
    private String accessCheckpoint(String database) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.accessCheckpoint(database, null);
        }
        return this.accessCheckpoint(database, null);
    }

    @Generated
    public <T> T getDoc(String id, String database, Class type) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        return this.getDoc(id, database, type, false);
    }

    @Generated
    public Operation updateDoc(Object doc) {
        Reference<Object> doc2 = new Reference<Object>(doc);
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        return this.updateDoc(doc2.get(), null);
    }

    @Generated
    public Operation removeDoc(Object doc) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        return this.removeDoc(doc, null);
    }

    @Generated
    public View getView(String document_id, String view_id, String database) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        return this.getView(document_id, view_id, database, ScriptBytecodeAdapter.createMap(new Object[0]));
    }

    @Generated
    public View getAll(String database) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        return this.getAll(database, ScriptBytecodeAdapter.createMap(new Object[0]));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CouchHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = bigDecimal = new BigDecimal("0.9");
    }

    static {
        Object object;
        CouchHandler.__$swapInit();
        cachedDocuments = object = CouchHandler.$getCallSiteArray()[392].callConstructor(ConcurrentHashMap.class);
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public void setAddress(String string) {
        this.address = string;
    }

    @Generated
    public static Object getCachedDocuments() {
        return cachedDocuments;
    }

    @Generated
    public static void setCachedDocuments(Object object) {
        cachedDocuments = object;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "configure";
        stringArray[2] = "FAIL_ON_UNKNOWN_PROPERTIES";
        stringArray[3] = "configure";
        stringArray[4] = "FAIL_ON_EMPTY_BEANS";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "addSerializer";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "registerModule";
        stringArray[9] = "normalizeAddress";
        stringArray[10] = "authenticate";
        stringArray[11] = "authenticate";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "endsWith";
        stringArray[14] = "plus";
        stringArray[15] = "startsWith";
        stringArray[16] = "toLowerCase";
        stringArray[17] = "startsWith";
        stringArray[18] = "toLowerCase";
        stringArray[19] = "plus";
        stringArray[20] = "startsWith";
        stringArray[21] = "toLowerCase";
        stringArray[22] = "startsWith";
        stringArray[23] = "toLowerCase";
        stringArray[24] = "plus";
        stringArray[25] = "authenticate";
        stringArray[26] = "username";
        stringArray[27] = "main";
        stringArray[28] = "memory cores";
        stringArray[29] = "config";
        stringArray[30] = "password";
        stringArray[31] = "main";
        stringArray[32] = "memory cores";
        stringArray[33] = "config";
        stringArray[34] = "promptInput";
        stringArray[35] = "promptInput";
        stringArray[36] = "promptPasswordInput";
        stringArray[37] = "plus";
        stringArray[38] = "plus";
        stringArray[39] = "promptPasswordInput";
        stringArray[40] = "plus";
        stringArray[41] = "plus";
        stringArray[42] = "encodePath";
        stringArray[43] = "plus";
        stringArray[44] = "post";
        stringArray[45] = "toString";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "error";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "getAt";
        stringArray[50] = "headers";
        stringArray[51] = "find";
        stringArray[52] = "getAt";
        stringArray[53] = "split";
        stringArray[54] = "getAt";
        stringArray[55] = "split";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "parseSessionExpiry";
        stringArray[58] = "debug";
        stringArray[59] = "plus";
        stringArray[60] = "plus";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "error";
        stringArray[63] = "error";
        stringArray[64] = "plus";
        stringArray[65] = "message";
        stringArray[66] = "parseLong";
        stringArray[67] = "getAt";
        stringArray[68] = "getAt";
        stringArray[69] = "plus";
        stringArray[70] = "currentTimeMillis";
        stringArray[71] = "multiply";
        stringArray[72] = "multiply";
        stringArray[73] = "plus";
        stringArray[74] = "currentTimeMillis";
        stringArray[75] = "multiply";
        stringArray[76] = "trim";
        stringArray[77] = "getAt";
        stringArray[78] = "getAt";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "ENGLISH";
        stringArray[81] = "parse";
        stringArray[82] = "minus";
        stringArray[83] = "time";
        stringArray[84] = "currentTimeMillis";
        stringArray[85] = "plus";
        stringArray[86] = "currentTimeMillis";
        stringArray[87] = "multiply";
        stringArray[88] = "debug";
        stringArray[89] = "plus";
        stringArray[90] = "currentTimeMillis";
        stringArray[91] = "multiply";
        stringArray[92] = "multiply";
        stringArray[93] = "plus";
        stringArray[94] = "currentTimeMillis";
        stringArray[95] = "debug";
        stringArray[96] = "plus";
        stringArray[97] = "plus";
        stringArray[98] = "message";
        stringArray[99] = "plus";
        stringArray[100] = "currentTimeMillis";
        stringArray[101] = "multiply";
        stringArray[102] = "multiply";
        stringArray[103] = "plus";
        stringArray[104] = "currentTimeMillis";
        stringArray[105] = "currentTimeMillis";
        stringArray[106] = "debug";
        stringArray[107] = "authenticate";
        stringArray[108] = "error";
        stringArray[109] = "ensureValidSession";
        stringArray[110] = "encodePath";
        stringArray[111] = "plus";
        stringArray[112] = "body";
        stringArray[113] = "put";
        stringArray[114] = "plus";
        stringArray[115] = "toString";
        stringArray[116] = "<$constructor$>";
        stringArray[117] = "readValue";
        stringArray[118] = "ensureValidSession";
        stringArray[119] = "containsDatabase";
        stringArray[120] = "success";
        stringArray[121] = "createDatabase";
        stringArray[122] = "success";
        stringArray[123] = "ensureValidSession";
        stringArray[124] = "body";
        stringArray[125] = "get";
        stringArray[126] = "plus";
        stringArray[127] = "plus";
        stringArray[128] = "parseText";
        stringArray[129] = "<$constructor$>";
        stringArray[130] = "ensureValidSession";
        stringArray[131] = "encodePath";
        stringArray[132] = "plus";
        stringArray[133] = "body";
        stringArray[134] = "delete";
        stringArray[135] = "plus";
        stringArray[136] = "readValue";
        stringArray[137] = "ensureValidSession";
        stringArray[138] = "body";
        stringArray[139] = "get";
        stringArray[140] = "plus";
        stringArray[141] = "plus";
        stringArray[142] = "contains";
        stringArray[143] = "parseText";
        stringArray[144] = "<$constructor$>";
        stringArray[145] = "ensureValidSession";
        stringArray[146] = "findAll";
        stringArray[147] = "plus";
        stringArray[148] = "plus";
        stringArray[149] = "body";
        stringArray[150] = "get";
        stringArray[151] = "plus";
        stringArray[152] = "parseText";
        stringArray[153] = "<$constructor$>";
        stringArray[154] = "error";
        stringArray[155] = "printStackTrace";
        stringArray[156] = "get";
        stringArray[157] = "getAt";
        stringArray[158] = "containsKey";
        stringArray[159] = "getAt";
        stringArray[160] = "putAt";
        stringArray[161] = "accessCheckpoint";
        stringArray[162] = "putAt";
        stringArray[163] = "getAt";
        stringArray[164] = "containsKey";
        stringArray[165] = "getAt";
        stringArray[166] = "putAt";
        stringArray[167] = "putAt";
        stringArray[168] = "getChanges";
        stringArray[169] = "last_seq";
        stringArray[170] = "last_seq";
        stringArray[171] = "putAt";
        stringArray[172] = "accessCheckpoint";
        stringArray[173] = "ensureValidSession";
        stringArray[174] = "createDatabaseIfNotExists";
        stringArray[175] = "getDoc";
        stringArray[176] = "updateDoc";
        stringArray[177] = "put";
        stringArray[178] = "plus";
        stringArray[179] = "plus";
        stringArray[180] = "plus";
        stringArray[181] = "plus";
        stringArray[182] = "writeValueAsString";
        stringArray[183] = "last_seq";
        stringArray[184] = "debug";
        stringArray[185] = "message";
        stringArray[186] = "getAt";
        stringArray[187] = "containsKey";
        stringArray[188] = "plus";
        stringArray[189] = "plus";
        stringArray[190] = "getClass";
        stringArray[191] = "getAt";
        stringArray[192] = "plus";
        stringArray[193] = "plus";
        stringArray[194] = "getClass";
        stringArray[195] = "getAt";
        stringArray[196] = "plus";
        stringArray[197] = "plus";
        stringArray[198] = "debug";
        stringArray[199] = "plus";
        stringArray[200] = "plus";
        stringArray[201] = "plus";
        stringArray[202] = "plus";
        stringArray[203] = "getAt";
        stringArray[204] = "plus";
        stringArray[205] = "plus";
        stringArray[206] = "containsKey";
        stringArray[207] = "plus";
        stringArray[208] = "plus";
        stringArray[209] = "getClass";
        stringArray[210] = "getAt";
        stringArray[211] = "plus";
        stringArray[212] = "plus";
        stringArray[213] = "getClass";
        stringArray[214] = "getAt";
        stringArray[215] = "plus";
        stringArray[216] = "plus";
        stringArray[217] = "debug";
        stringArray[218] = "plus";
        stringArray[219] = "plus";
        stringArray[220] = "plus";
        stringArray[221] = "plus";
        stringArray[222] = "getAt";
        stringArray[223] = "plus";
        stringArray[224] = "plus";
        stringArray[225] = "ensureValidSession";
        stringArray[226] = "body";
        stringArray[227] = "get";
        stringArray[228] = "plus";
        stringArray[229] = "plus";
        stringArray[230] = "plus";
        stringArray[231] = "plus";
        stringArray[232] = "readValue";
        stringArray[233] = "_id";
        stringArray[234] = "put";
        stringArray[235] = "plus";
        stringArray[236] = "plus";
        stringArray[237] = "debug";
        stringArray[238] = "plus";
        stringArray[239] = "plus";
        stringArray[240] = "plus";
        stringArray[241] = "plus";
        stringArray[242] = "printStackTrace";
        stringArray[243] = "ensureValidSession";
        stringArray[244] = "body";
        stringArray[245] = "get";
        stringArray[246] = "plus";
        stringArray[247] = "plus";
        stringArray[248] = "plus";
        stringArray[249] = "plus";
        stringArray[250] = "readValue";
        stringArray[251] = "_id";
        stringArray[252] = "printStackTrace";
        stringArray[253] = "ensureValidSession";
        stringArray[254] = "encodePath";
        stringArray[255] = "plus";
        stringArray[256] = "plus";
        stringArray[257] = "plus";
        stringArray[258] = "plus";
        stringArray[259] = "plus";
        stringArray[260] = "createDefault";
        stringArray[261] = "<$constructor$>";
        stringArray[262] = "setHeader";
        stringArray[263] = "plus";
        stringArray[264] = "execute";
        stringArray[265] = "getEntity";
        stringArray[266] = "value";
        stringArray[267] = "getContentType";
        stringArray[268] = "getContentLength";
        stringArray[269] = "writeTo";
        stringArray[270] = "consume";
        stringArray[271] = "printStackTrace";
        stringArray[272] = "close";
        stringArray[273] = "printStackTrace";
        stringArray[274] = "close";
        stringArray[275] = "printStackTrace";
        stringArray[276] = "ensureValidSession";
        stringArray[277] = "plus";
        stringArray[278] = "plus";
        stringArray[279] = "plus";
        stringArray[280] = "body";
        stringArray[281] = "put";
        stringArray[282] = "plus";
        stringArray[283] = "toString";
        stringArray[284] = "<$constructor$>";
        stringArray[285] = "readValue";
        stringArray[286] = "ensureValidSession";
        stringArray[287] = "database";
        stringArray[288] = "plus";
        stringArray[289] = "plus";
        stringArray[290] = "plus";
        stringArray[291] = "_id";
        stringArray[292] = "hasProperty";
        stringArray[293] = "customProperties";
        stringArray[294] = "size";
        stringArray[295] = "customProperties";
        stringArray[296] = "debug";
        stringArray[297] = "plus";
        stringArray[298] = "customProperties";
        stringArray[299] = "addAll";
        stringArray[300] = "customProperties";
        stringArray[301] = "hasProperty";
        stringArray[302] = "customProperties";
        stringArray[303] = "size";
        stringArray[304] = "customProperties";
        stringArray[305] = "debug";
        stringArray[306] = "plus";
        stringArray[307] = "customProperties";
        stringArray[308] = "addAll";
        stringArray[309] = "customProperties";
        stringArray[310] = "each";
        stringArray[311] = "each";
        stringArray[312] = "additionalProperties";
        stringArray[313] = "body";
        stringArray[314] = "put";
        stringArray[315] = "plus";
        stringArray[316] = "writeValueAsString";
        stringArray[317] = "readValue";
        stringArray[318] = "error";
        stringArray[319] = "plus";
        stringArray[320] = "message";
        stringArray[321] = "printStackTrace";
        stringArray[322] = "ensureValidSession";
        stringArray[323] = "plus";
        stringArray[324] = "plus";
        stringArray[325] = "plus";
        stringArray[326] = "plus";
        stringArray[327] = "plus";
        stringArray[328] = "body";
        stringArray[329] = "delete";
        stringArray[330] = "plus";
        stringArray[331] = "readValue";
        stringArray[332] = "error";
        stringArray[333] = "plus";
        stringArray[334] = "message";
        stringArray[335] = "printStackTrace";
        stringArray[336] = "ensureValidSession";
        stringArray[337] = "database";
        stringArray[338] = "plus";
        stringArray[339] = "plus";
        stringArray[340] = "plus";
        stringArray[341] = "_id";
        stringArray[342] = "debug";
        stringArray[343] = "plus";
        stringArray[344] = "plus";
        stringArray[345] = "plus";
        stringArray[346] = "plus";
        stringArray[347] = "_id";
        stringArray[348] = "body";
        stringArray[349] = "delete";
        stringArray[350] = "plus";
        stringArray[351] = "_rev";
        stringArray[352] = "error";
        stringArray[353] = "plus";
        stringArray[354] = "message";
        stringArray[355] = "printStackTrace";
        stringArray[356] = "readValue";
        stringArray[357] = "ok";
        stringArray[358] = "rev";
        stringArray[359] = "ensureValidSession";
        stringArray[360] = "replace";
        stringArray[361] = "body";
        stringArray[362] = "get";
        stringArray[363] = "plus";
        stringArray[364] = "plus";
        stringArray[365] = "plus";
        stringArray[366] = "plus";
        stringArray[367] = "plus";
        stringArray[368] = "plus";
        stringArray[369] = "readValue";
        stringArray[370] = "<$constructor$>";
        stringArray[371] = "error";
        stringArray[372] = "plus";
        stringArray[373] = "plus";
        stringArray[374] = "plus";
        stringArray[375] = "plus";
        stringArray[376] = "plus";
        stringArray[377] = "plus";
        stringArray[378] = "plus";
        stringArray[379] = "plus";
        stringArray[380] = "error";
        stringArray[381] = "printStackTrace";
        stringArray[382] = "ensureValidSession";
        stringArray[383] = "body";
        stringArray[384] = "get";
        stringArray[385] = "plus";
        stringArray[386] = "plus";
        stringArray[387] = "plus";
        stringArray[388] = "plus";
        stringArray[389] = "plus";
        stringArray[390] = "readValue";
        stringArray[391] = "<$constructor$>";
        stringArray[392] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[393];
        CouchHandler.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(CouchHandler.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = CouchHandler.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

