/*
 * Decompiled with CFR 0.152.
 */
package spaceport.computer.memory.physical;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import groovy.json.JsonBuilder;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.eclipse.jetty.util.URIUtil;
import spaceport.Spaceport;
import spaceport.bridge.Command;
import spaceport.communications.http.HTTP;
import spaceport.computer.memory.physical.Document;
import spaceport.computer.memory.physical.Operation;
import spaceport.computer.memory.physical.View;
import spaceport.computer.memory.virtual.Cargo;
import spaceport.computer.memory.virtual.CargoSerializer;

public class CouchHandler
implements GroovyObject {
    private final ObjectMapper objectMapper;
    private String address;
    private String cookie;
    private String storedUsername;
    private String storedPassword;
    private long sessionExpiryTime;
    private static Object cachedDocuments;
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public CouchHandler(String address, String user, String pass) {
        MetaClass metaClass;
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        int n = 0;
        this.sessionExpiryTime = n;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callConstructor(ObjectMapper.class);
        this.objectMapper = (ObjectMapper)ScriptBytecodeAdapter.castToType(object, ObjectMapper.class);
        callSiteArray[1].call(this.objectMapper, callSiteArray[2].callGetProperty(DeserializationFeature.class), false);
        callSiteArray[3].call(this.objectMapper, callSiteArray[4].callGetProperty(SerializationFeature.class), false);
        SimpleModule module = (SimpleModule)ScriptBytecodeAdapter.castToType(callSiteArray[5].callConstructor(SimpleModule.class), SimpleModule.class);
        callSiteArray[6].call(module, Cargo.class, callSiteArray[7].callConstructor(CargoSerializer.class));
        callSiteArray[8].call((Object)this.objectMapper, module);
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[9].callCurrent((GroovyObject)this, address);
            this.address = ShortTypeHandling.castToString(object2);
        } else {
            String string;
            this.address = string = this.normalizeAddress(address);
        }
        if (!BytecodeInterface8.isOrigZ() || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual(user, null) && ScriptBytecodeAdapter.compareNotEqual(pass, null)) {
                callSiteArray[10].callCurrent(this, user, pass);
            } else {
                callSiteArray[11].callCurrent(this);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual(user, null) && ScriptBytecodeAdapter.compareNotEqual(pass, null)) {
            this.authenticate(user, pass);
        } else {
            this.authenticate();
        }
    }

    public CouchHandler(String address) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        this(address, null, null);
    }

    private String normalizeAddress(String addr) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual(addr, null)) {
            throw (Throwable)callSiteArray[12].callConstructor(IllegalArgumentException.class, "Address cannot be null");
        }
        String normalized = addr;
        if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[13].call((Object)normalized, "/"))) {
            normalized = ShortTypeHandling.castToString(callSiteArray[14].call((Object)normalized, "/"));
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[15].call(callSiteArray[16].call(normalized), "http://")) && !DefaultTypeTransformation.booleanUnbox(callSiteArray[17].call(callSiteArray[18].call(normalized), "https://"))) {
                normalized = ShortTypeHandling.castToString(callSiteArray[19].call((Object)"http://", normalized));
            }
        } else if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[20].call(callSiteArray[21].call(normalized), "http://")) && !DefaultTypeTransformation.booleanUnbox(callSiteArray[22].call(callSiteArray[23].call(normalized), "https://"))) {
            normalized = ShortTypeHandling.castToString(callSiteArray[24].call((Object)"http://", normalized));
        }
        return normalized;
    }

    public void authenticate() {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        callSiteArray[25].callCurrent(this, callSiteArray[26].callGetProperty(callSiteArray[27].callGetProperty(callSiteArray[28].callGetProperty(callSiteArray[29].callGetProperty(Spaceport.class)))), callSiteArray[30].callGetProperty(callSiteArray[31].callGetProperty(callSiteArray[32].callGetProperty(callSiteArray[33].callGetProperty(Spaceport.class)))));
    }

    public void authenticate(String user, String pass) {
        Object response;
        CallSite[] callSiteArray;
        block17: {
            String string;
            String string2;
            callSiteArray = CouchHandler.$getCallSiteArray();
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual(user, null) || ScriptBytecodeAdapter.compareEqual(user, "")) {
                    user = ShortTypeHandling.castToString(callSiteArray[34].call(Command.class, "Enter COUCHDB username: "));
                }
            } else if (ScriptBytecodeAdapter.compareEqual(user, null) || ScriptBytecodeAdapter.compareEqual(user, "")) {
                user = ShortTypeHandling.castToString(callSiteArray[35].call(Command.class, "Enter COUCHDB username: "));
            }
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (!DefaultTypeTransformation.booleanUnbox(pass) || ScriptBytecodeAdapter.compareEqual(pass, "")) {
                    pass = ShortTypeHandling.castToString(callSiteArray[36].call(Command.class, callSiteArray[37].call(callSiteArray[38].call((Object)"Enter password for COUCHDB user '", user), "': ")));
                }
            } else if (!DefaultTypeTransformation.booleanUnbox(pass) || ScriptBytecodeAdapter.compareEqual(pass, "")) {
                pass = ShortTypeHandling.castToString(callSiteArray[39].call(Command.class, callSiteArray[40].call(callSiteArray[41].call((Object)"Enter password for COUCHDB user '", user), "': ")));
            }
            this.storedUsername = string2 = user;
            this.storedPassword = string = pass;
            Object url = callSiteArray[42].call(URIUtil.class, callSiteArray[43].call((Object)this.address, "_session"));
            response = callSiteArray[44].call(HTTP.class, url, ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Content-Type", "application/json"}), "body", callSiteArray[45].call(callSiteArray[46].callConstructor(JsonBuilder.class, ScriptBytecodeAdapter.createMap(new Object[]{"name", user, "password", pass})))}));
            if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[47].callGetProperty(response))) break block17;
            throw (Throwable)callSiteArray[48].callConstructor(Exception.class);
        }
        try {
            Object setCookieHeader = callSiteArray[49].call(callSiteArray[50].callGetProperty(response), "Set-Cookie");
            String cookieHeaderStr = ShortTypeHandling.castToString(setCookieHeader);
            if (setCookieHeader instanceof List) {
                public final class _authenticate_closure1
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _authenticate_closure1(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _authenticate_closure1.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _authenticate_closure1.$getCallSiteArray();
                        return callSiteArray[0].call(it, "AuthSession");
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _authenticate_closure1.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (this.getClass() != _authenticate_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass(this);
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "contains";
                        return new CallSiteArray(_authenticate_closure1.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _authenticate_closure1.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                cookieHeaderStr = ShortTypeHandling.castToString(callSiteArray[51].call(setCookieHeader, new _authenticate_closure1(this, this)));
            }
            Object object = callSiteArray[52].call(callSiteArray[53].call(callSiteArray[54].call(callSiteArray[55].call((Object)cookieHeaderStr, "="), 1), ";"), 0);
            this.cookie = ShortTypeHandling.castToString(object);
            if (!DefaultTypeTransformation.booleanUnbox(this.cookie)) {
                throw (Throwable)callSiteArray[56].callConstructor(Exception.class, "No AuthSession cookie from CouchDB. Invalid username or password?");
            }
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[57].callCurrent((GroovyObject)this, cookieHeaderStr);
            } else {
                this.parseSessionExpiry(cookieHeaderStr);
            }
            callSiteArray[58].call(Command.class, callSiteArray[59].call(callSiteArray[60].call((Object)"[GREEN]Successfully authenticated with CouchDB. Session expires at: ", callSiteArray[61].callConstructor(Date.class, this.sessionExpiryTime)), "[RESET]"));
        }
        catch (Exception e) {
            callSiteArray[62].call(Command.class, "Failed to authenticate.");
            callSiteArray[63].call(Command.class, callSiteArray[64].call((Object)"Message: ", callSiteArray[65].callGetProperty(e)));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseSessionExpiry(String setCookieHeader) {
        block10: {
            block9: {
                var2_2 = CouchHandler.$getCallSiteArray();
                maxAgeMatch = ScriptBytecodeAdapter.findRegex(setCookieHeader, "Max-Age=(\\d+)");
                if (!DefaultTypeTransformation.booleanUnbox(maxAgeMatch)) ** GOTO lbl24
                maxAge = DefaultTypeTransformation.longUnbox(var2_2[66].call(Long.class, ScriptBytecodeAdapter.createPojoWrapper((String)ScriptBytecodeAdapter.asType(var2_2[67].call(var2_2[68].call((Object)maxAgeMatch, 0), 1), String.class), String.class)));
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigL() || CouchHandler.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    var6_5 = var2_2[69].call(var2_2[70].call(System.class), DefaultTypeTransformation.longUnbox(var2_2[71].call(var2_2[72].call((Object)maxAge, 1000), CouchHandler.$const$0)));
                    this.sessionExpiryTime = DefaultTypeTransformation.longUnbox(var6_5);
                    break block9;
                }
                var7_6 = var2_2[73].call(var2_2[74].call(System.class), DefaultTypeTransformation.longUnbox(var2_2[75].call((Object)(maxAge * (long)1000), CouchHandler.$const$0)));
                this.sessionExpiryTime = DefaultTypeTransformation.longUnbox(var7_6);
            }
            return;
lbl24:
            // 1 sources

            expiresMatch = ScriptBytecodeAdapter.findRegex(setCookieHeader, "Expires=([^;]+)");
            if (!DefaultTypeTransformation.booleanUnbox(expiresMatch)) ** GOTO lbl44
            expiresStr = ShortTypeHandling.castToString(var2_2[76].call((String)ScriptBytecodeAdapter.asType(var2_2[77].call(var2_2[78].call((Object)expiresMatch, 0), 1), String.class)));
            dateFormat = var2_2[79].callConstructor(SimpleDateFormat.class, "EEE, dd-MMM-yyyy HH:mm:ss zzz", var2_2[80].callGetProperty(Locale.class));
            expiryDate = (Date)ScriptBytecodeAdapter.castToType(var2_2[81].call(dateFormat, expiresStr), Date.class);
            timeUntilExpiry = DefaultTypeTransformation.longUnbox(var2_2[82].call(var2_2[83].callGetProperty(expiryDate), var2_2[84].call(System.class)));
            var14_12 = var2_2[85].call(var2_2[86].call(System.class), DefaultTypeTransformation.longUnbox(var2_2[87].call((Object)timeUntilExpiry, CouchHandler.$const$0)));
            this.sessionExpiryTime = DefaultTypeTransformation.longUnbox(var14_12);
            try {
                return;
lbl44:
                // 1 sources

                var2_2[88].call(Command.class, "[YELLOW]Could not parse session expiry, defaulting to 10 minutes[RESET]");
                if (!BytecodeInterface8.isOrigInt() || CouchHandler.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    var15_13 = var2_2[89].call(var2_2[90].call(System.class), var2_2[91].call(var2_2[92].call((Object)10, 60), 1000));
                    this.sessionExpiryTime = DefaultTypeTransformation.longUnbox(var15_13);
                    break block10;
                }
                var16_14 = var2_2[93].call(var2_2[94].call(System.class), 10 * 60 * 1000);
                this.sessionExpiryTime = DefaultTypeTransformation.longUnbox(var16_14);
            }
            catch (Exception e) {
                var2_2[95].call(Command.class, var2_2[96].call(var2_2[97].call((Object)"[YELLOW]Error parsing session expiry: ", var2_2[98].callGetProperty(e)), ", defaulting to 10 minutes[RESET]"));
                if (!BytecodeInterface8.isOrigInt() || CouchHandler.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    var18_16 = var2_2[99].call(var2_2[100].call(System.class), var2_2[101].call(var2_2[102].call((Object)10, 60), 1000));
                    this.sessionExpiryTime = DefaultTypeTransformation.longUnbox(var18_16);
                    break block10;
                }
                var19_17 = var2_2[103].call(var2_2[104].call(System.class), 10 * 60 * 1000);
                this.sessionExpiryTime = DefaultTypeTransformation.longUnbox(var19_17);
            }
        }
    }

    private boolean ensureValidSession() {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareGreaterThanEqual(callSiteArray[105].call(System.class), this.sessionExpiryTime)) {
            callSiteArray[106].call(Command.class, "[YELLOW]Session expired or about to expire, refreshing...[RESET]");
            if (DefaultTypeTransformation.booleanUnbox(this.storedUsername) && DefaultTypeTransformation.booleanUnbox(this.storedPassword)) {
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    callSiteArray[107].callCurrent(this, this.storedUsername, this.storedPassword);
                } else {
                    this.authenticate(this.storedUsername, this.storedPassword);
                }
                return ScriptBytecodeAdapter.compareNotEqual(this.cookie, null);
            }
            callSiteArray[108].call(Command.class, "Cannot refresh session: no stored credentials");
            return false;
        }
        return true;
    }

    public Object createDatabase(String id) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[109].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object url = callSiteArray[110].call(URIUtil.class, callSiteArray[111].call((Object)this.address, id));
        Object returned = callSiteArray[112].callGetProperty(callSiteArray[113].call(HTTP.class, url, ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[114].call((Object)"AuthSession=", this.cookie)}), "body", callSiteArray[115].call(callSiteArray[116].callConstructor(JsonBuilder.class, ScriptBytecodeAdapter.createMap(new Object[0])))})));
        return callSiteArray[117].call(this.objectMapper, returned, Operation.class);
    }

    public Object deleteDatabase(String id) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[118].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object url = callSiteArray[119].call(URIUtil.class, callSiteArray[120].call((Object)this.address, id));
        Object returned = callSiteArray[121].callGetProperty(callSiteArray[122].call(HTTP.class, url, ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[123].call((Object)"AuthSession=", this.cookie)})})));
        return callSiteArray[124].call(this.objectMapper, returned, Operation.class);
    }

    public boolean containsDatabase(String id) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[125].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object returned = callSiteArray[126].callGetProperty(callSiteArray[127].call(HTTP.class, ScriptBytecodeAdapter.createPojoWrapper((String)ScriptBytecodeAdapter.asType(callSiteArray[128].call((Object)this.address, "_all_dbs"), String.class), String.class), ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[129].call((Object)"AuthSession=", this.cookie)})})));
        return DefaultTypeTransformation.booleanUnbox(callSiteArray[130].call((Object)((List)ScriptBytecodeAdapter.asType(callSiteArray[131].call(callSiteArray[132].callConstructor(JsonSlurper.class), returned), List.class)), id));
    }

    /*
     * Unable to fully structure code
     */
    public <T> T getDoc(String id, String database, Class type, Object ignoreCache) {
        var5_5 = CouchHandler.$getCallSiteArray();
        if (BytecodeInterface8.isOrigZ() == false || CouchHandler.__$stMC != false || BytecodeInterface8.disabledStandardMetaClass() != false ? (ScriptBytecodeAdapter.compareEqual(database, null) != false || ScriptBytecodeAdapter.compareEqual(id, null) != false) != false : (ScriptBytecodeAdapter.compareEqual(database, null) != false || ScriptBytecodeAdapter.compareEqual(id, null) != false) != false) {
            return null;
        }
        if (!BytecodeInterface8.isOrigZ() || CouchHandler.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if ((DefaultTypeTransformation.booleanUnbox(ignoreCache) == false != false && DefaultTypeTransformation.booleanUnbox(var5_5[133].call(CouchHandler.cachedDocuments, var5_5[134].call(var5_5[135].call((Object)id, "/"), database))) != false) != false && (ScriptBytecodeAdapter.compareEqual(var5_5[136].call(var5_5[137].call(CouchHandler.cachedDocuments, var5_5[138].call(var5_5[139].call((Object)id, "/"), database))), type) != false || ScriptBytecodeAdapter.compareNotEqual(var5_5[140].call(var5_5[141].call(CouchHandler.cachedDocuments, var5_5[142].call(var5_5[143].call((Object)id, "/"), database))), Document.class) != false) != false) {
                var5_5[144].call(Command.class, var5_5[145].call(var5_5[146].call(var5_5[147].call(var5_5[148].call((Object)"[MAGENTA]Returned cached document ", id), "/"), database), "[RESET]"));
                return (T)var5_5[149].call(CouchHandler.cachedDocuments, var5_5[150].call(var5_5[151].call((Object)id, "/"), database));
            }
        } else if ((DefaultTypeTransformation.booleanUnbox(ignoreCache) == false != false && DefaultTypeTransformation.booleanUnbox(var5_5[152].call(CouchHandler.cachedDocuments, var5_5[153].call(var5_5[154].call((Object)id, "/"), database))) != false) != false && (ScriptBytecodeAdapter.compareEqual(var5_5[155].call(var5_5[156].call(CouchHandler.cachedDocuments, var5_5[157].call(var5_5[158].call((Object)id, "/"), database))), type) != false || ScriptBytecodeAdapter.compareNotEqual(var5_5[159].call(var5_5[160].call(CouchHandler.cachedDocuments, var5_5[161].call(var5_5[162].call((Object)id, "/"), database))), Document.class) != false) != false) {
            var5_5[163].call(Command.class, var5_5[164].call(var5_5[165].call(var5_5[166].call(var5_5[167].call((Object)"[MAGENTA]Returned cached document ", id), "/"), database), "[RESET]"));
            return (T)var5_5[168].call(CouchHandler.cachedDocuments, var5_5[169].call(var5_5[170].call((Object)id, "/"), database));
        }
        if (CouchHandler.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            var5_5[171].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        returned = var5_5[172].callGetProperty(var5_5[173].call(HTTP.class, ScriptBytecodeAdapter.createPojoWrapper((String)ScriptBytecodeAdapter.asType(var5_5[174].call(var5_5[175].call(var5_5[176].call((Object)this.address, database), "/"), id), String.class), String.class), ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", var5_5[177].call((Object)"AuthSession=", this.cookie)})})));
        doc = var5_5[178].call(this.objectMapper, returned, type);
        if (!ScriptBytecodeAdapter.compareEqual(var5_5[179].callGetProperty(doc), null)) ** GOTO lbl32
        var8_8 = null;
        return var8_8;
lbl32:
        // 1 sources

        var9_9 = database;
        ScriptBytecodeAdapter.setProperty(var9_9, null, doc, "database");
        if (DefaultTypeTransformation.booleanUnbox(ignoreCache) == false) {
            var5_5[180].call(CouchHandler.cachedDocuments, var5_5[181].call(var5_5[182].call((Object)id, "/"), database), ScriptBytecodeAdapter.createPojoWrapper(doc, Object.class));
            var5_5[183].call(Command.class, var5_5[184].call(var5_5[185].call(var5_5[186].call(var5_5[187].call((Object)"[MAGENTA]Added ", id), "/"), database), " to cache.[RESET]"));
        }
        var10_10 = doc;
        try {
            return (T)var10_10;
        }
        catch (Exception e) {
            var5_5[188].call(e);
            var12_12 = null;
            return var12_12;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Document getDocRevision(String id, String database, Object rev) {
        var4_4 = CouchHandler.$getCallSiteArray();
        if (BytecodeInterface8.isOrigZ() == false || CouchHandler.__$stMC != false || BytecodeInterface8.disabledStandardMetaClass() != false ? (ScriptBytecodeAdapter.compareEqual(database, null) != false || ScriptBytecodeAdapter.compareEqual(id, null) != false) != false : (ScriptBytecodeAdapter.compareEqual(database, null) != false || ScriptBytecodeAdapter.compareEqual(id, null) != false) != false) {
            return (Document)ScriptBytecodeAdapter.castToType(null, Document.class);
        }
        if (CouchHandler.__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            var4_4[189].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        if (!ScriptBytecodeAdapter.compareEqual(rev, null)) ** GOTO lbl18
        var5_5 = (Document)ScriptBytecodeAdapter.castToType(null, Document.class);
        return var5_5;
lbl18:
        // 1 sources

        returned = var4_4[190].callGetProperty(var4_4[191].call(HTTP.class, ScriptBytecodeAdapter.createPojoWrapper((String)ScriptBytecodeAdapter.asType(var4_4[192].call(var4_4[193].call(var4_4[194].call((Object)this.address, database), "/"), id), String.class), String.class), ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", var4_4[195].call((Object)"AuthSession=", this.cookie)}), "queryParams", ScriptBytecodeAdapter.createMap(new Object[]{"rev", rev})})));
        doc = var4_4[196].call(this.objectMapper, returned, Document.class);
        if (!ScriptBytecodeAdapter.compareEqual(var4_4[197].callGetProperty(doc), null)) ** GOTO lbl28
        var8_8 = (Document)ScriptBytecodeAdapter.castToType(null, Document.class);
        return var8_8;
lbl28:
        // 1 sources

        var9_9 = database;
        ScriptBytecodeAdapter.setProperty(var9_9, null, doc, "database");
        var10_10 = (Document)ScriptBytecodeAdapter.castToType(doc, Document.class);
        try {
            return var10_10;
        }
        catch (Exception e) {
            var4_4[198].call(e);
            var12_12 = (Document)ScriptBytecodeAdapter.castToType(null, Document.class);
            return var12_12;
        }
    }

    public Map getDocAttachment(String attachment, String id, String database, OutputStream o) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[199].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object url = callSiteArray[200].call(URIUtil.class, callSiteArray[201].call(callSiteArray[202].call(callSiteArray[203].call(callSiteArray[204].call(callSiteArray[205].call((Object)this.address, database), "/"), id), "/"), attachment));
        CloseableHttpClient httpClient = (CloseableHttpClient)ScriptBytecodeAdapter.castToType(callSiteArray[206].call(HttpClients.class), CloseableHttpClient.class);
        HttpGet httpGet = (HttpGet)ScriptBytecodeAdapter.castToType(callSiteArray[207].callConstructor(HttpGet.class, url), HttpGet.class);
        callSiteArray[208].call(httpGet, "Cookie", callSiteArray[209].call((Object)"AuthSession=", this.cookie));
        CloseableHttpResponse response = null;
        Map returned = ScriptBytecodeAdapter.createMap(new Object[0]);
        try {
            try {
                response = (CloseableHttpResponse)ScriptBytecodeAdapter.castToType(callSiteArray[210].call((Object)httpClient, httpGet), CloseableHttpResponse.class);
                HttpEntity entity = (HttpEntity)ScriptBytecodeAdapter.castToType(callSiteArray[211].call(response), HttpEntity.class);
                returned = ScriptBytecodeAdapter.createMap(new Object[]{"content_type", callSiteArray[212].callGetProperty(callSiteArray[213].call(entity)), "content_length", callSiteArray[214].call(entity)});
                callSiteArray[215].call((Object)entity, o);
                callSiteArray[216].call(EntityUtils.class, entity);
            }
            catch (Exception e) {
                callSiteArray[217].call(e);
            }
        }
        catch (Throwable throwable) {
            if (ScriptBytecodeAdapter.compareNotEqual(response, null)) {
                try {
                    callSiteArray[220].call(response);
                }
                catch (IOException e) {
                    callSiteArray[221].call(e);
                }
            }
            throw throwable;
        }
        if (ScriptBytecodeAdapter.compareNotEqual(response, null)) {
            try {
                callSiteArray[218].call(response);
            }
            catch (IOException e) {
                callSiteArray[219].call(e);
            }
        }
        return (Map)ScriptBytecodeAdapter.castToType(returned, Map.class);
    }

    public Operation addDoc(String id, String database) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[222].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object url = callSiteArray[223].call(callSiteArray[224].call(callSiteArray[225].call((Object)this.address, database), "/"), id);
        Object returned = callSiteArray[226].callGetProperty(callSiteArray[227].call(HTTP.class, url, ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[228].call((Object)"AuthSession=", this.cookie)}), "body", callSiteArray[229].call(callSiteArray[230].callConstructor(JsonBuilder.class, ScriptBytecodeAdapter.createMap(new Object[0])))})));
        return (Operation)ScriptBytecodeAdapter.castToType(callSiteArray[231].call(this.objectMapper, returned, Operation.class), Operation.class);
    }

    public Operation updateDoc(Object doc, String database) {
        Reference<Object> doc2 = new Reference<Object>(doc);
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[232].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        if (ScriptBytecodeAdapter.compareEqual(database, null)) {
            database = ShortTypeHandling.castToString(callSiteArray[233].callGetProperty(doc2.get()));
        }
        Object url = callSiteArray[234].call(callSiteArray[235].call(callSiteArray[236].call((Object)this.address, database), "/"), callSiteArray[237].callGetProperty(doc2.get()));
        Reference<List> properties = new Reference<List>(ScriptBytecodeAdapter.createList(new Object[]{"_id", "_rev", "type", "fields", "states", "cargo", "updates", "_attachments"}));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox(callSiteArray[238].call(doc2.get(), "customProperties")) && callSiteArray[239].callGetProperty(doc2.get()) instanceof List && ScriptBytecodeAdapter.compareGreaterThan(callSiteArray[240].call(callSiteArray[241].callGetProperty(doc2.get())), 0)) {
                callSiteArray[242].call(Command.class, callSiteArray[243].call((Object)"Added custom properties for update -> ", callSiteArray[244].callGetProperty(doc2.get())));
                callSiteArray[245].call((Object)properties.get(), callSiteArray[246].callGetProperty(doc2.get()));
            }
        } else if (DefaultTypeTransformation.booleanUnbox(callSiteArray[247].call(doc2.get(), "customProperties")) && callSiteArray[248].callGetProperty(doc2.get()) instanceof List && ScriptBytecodeAdapter.compareGreaterThan(callSiteArray[249].call(callSiteArray[250].callGetProperty(doc2.get())), 0)) {
            callSiteArray[251].call(Command.class, callSiteArray[252].call((Object)"Added custom properties for update -> ", callSiteArray[253].callGetProperty(doc2.get())));
            callSiteArray[254].call((Object)properties.get(), callSiteArray[255].callGetProperty(doc2.get()));
        }
        Reference<Map> filteredDoc = new Reference<Map>(ScriptBytecodeAdapter.createMap(new Object[0]));
        public final class _updateDoc_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference doc;
            private /* synthetic */ Reference filteredDoc;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateDoc_closure2(Object _outerInstance, Object _thisObject, Reference doc, Reference filteredDoc) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _updateDoc_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.doc = reference2 = doc;
                this.filteredDoc = reference = filteredDoc;
            }

            public Object doCall(Object property) {
                CallSite[] callSiteArray = _updateDoc_closure2.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox(callSiteArray[0].call(this.doc.get(), property))) {
                    Object object = callSiteArray[1].call(this.doc.get(), property);
                    callSiteArray[2].call(this.filteredDoc.get(), property, object);
                    return object;
                }
                return null;
            }

            @Generated
            public Object getDoc() {
                CallSite[] callSiteArray = _updateDoc_closure2.$getCallSiteArray();
                return this.doc.get();
            }

            @Generated
            public Object getFilteredDoc() {
                CallSite[] callSiteArray = _updateDoc_closure2.$getCallSiteArray();
                return this.filteredDoc.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _updateDoc_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "hasProperty";
                stringArray[1] = "getAt";
                stringArray[2] = "putAt";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _updateDoc_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateDoc_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateDoc_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[256].call((Object)properties.get(), new _updateDoc_closure2(this, this, doc2, filteredDoc));
        public final class _updateDoc_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference properties;
            private /* synthetic */ Reference filteredDoc;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateDoc_closure3(Object _outerInstance, Object _thisObject, Reference properties, Reference filteredDoc) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _updateDoc_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.properties = reference2 = properties;
                this.filteredDoc = reference = filteredDoc;
            }

            public Object doCall(Object property, Object value) {
                CallSite[] callSiteArray = _updateDoc_closure3.$getCallSiteArray();
                if (!DefaultTypeTransformation.booleanUnbox(callSiteArray[0].call(this.properties.get(), property))) {
                    Object object = value;
                    callSiteArray[1].call(this.filteredDoc.get(), property, object);
                    return object;
                }
                return null;
            }

            @Generated
            public Object call(Object property, Object value) {
                CallSite[] callSiteArray = _updateDoc_closure3.$getCallSiteArray();
                return callSiteArray[2].callCurrent(this, property, value);
            }

            @Generated
            public Object getProperties() {
                CallSite[] callSiteArray = _updateDoc_closure3.$getCallSiteArray();
                return this.properties.get();
            }

            @Generated
            public Object getFilteredDoc() {
                CallSite[] callSiteArray = _updateDoc_closure3.$getCallSiteArray();
                return this.filteredDoc.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _updateDoc_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "contains";
                stringArray[1] = "putAt";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _updateDoc_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateDoc_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateDoc_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[257].call(callSiteArray[258].callGetProperty(doc2.get()), new _updateDoc_closure3(this, this, properties, filteredDoc));
        Object response = callSiteArray[259].callGetProperty(callSiteArray[260].call(HTTP.class, url, ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[261].call((Object)"AuthSession=", this.cookie)}), "body", callSiteArray[262].call((Object)this.objectMapper, filteredDoc.get())})));
        Object operation = callSiteArray[263].call(this.objectMapper, response, Operation.class);
        Operation operation2 = (Operation)ScriptBytecodeAdapter.castToType(operation, Operation.class);
        try {
            return operation2;
        }
        catch (Exception e) {
            callSiteArray[264].call(Command.class, callSiteArray[265].call((Object)"Failed to update document: ", callSiteArray[266].callGetProperty(e)));
            callSiteArray[267].call(e);
            Operation operation3 = (Operation)ScriptBytecodeAdapter.castToType(null, Operation.class);
            return operation3;
        }
    }

    public Operation removeDocAttachment(String doc, String database, String rev, String attachment) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[268].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object url = callSiteArray[269].call(callSiteArray[270].call(callSiteArray[271].call(callSiteArray[272].call(callSiteArray[273].call((Object)this.address, database), "/"), doc), "/"), attachment);
        Object returned = callSiteArray[274].callGetProperty(callSiteArray[275].call(HTTP.class, url, ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[276].call((Object)"AuthSession=", this.cookie)}), "queryParams", ScriptBytecodeAdapter.createMap(new Object[]{"rev", rev})})));
        Operation operation = (Operation)ScriptBytecodeAdapter.castToType(callSiteArray[277].call(this.objectMapper, returned, Operation.class), Operation.class);
        try {
            return operation;
        }
        catch (Exception e) {
            callSiteArray[278].call(Command.class, callSiteArray[279].call((Object)"Failed to remove attachment: ", callSiteArray[280].callGetProperty(e)));
            callSiteArray[281].call(e);
            Operation operation2 = (Operation)ScriptBytecodeAdapter.castToType(null, Operation.class);
            return operation2;
        }
    }

    public Operation removeDoc(Object doc, String database) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[282].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        if (ScriptBytecodeAdapter.compareEqual(database, null)) {
            database = ShortTypeHandling.castToString(callSiteArray[283].callGetProperty(doc));
        }
        Object url = callSiteArray[284].call(callSiteArray[285].call(callSiteArray[286].call((Object)this.address, database), "/"), callSiteArray[287].callGetProperty(doc));
        Object returned = null;
        try {
            callSiteArray[288].call(Command.class, callSiteArray[289].call(callSiteArray[290].call(callSiteArray[291].call(callSiteArray[292].call((Object)"[RED]Removing document ", callSiteArray[293].callGetProperty(doc)), " from database "), database), "[RESET]"));
            returned = callSiteArray[294].callGetProperty(callSiteArray[295].call(HTTP.class, url, ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[296].call((Object)"AuthSession=", this.cookie)}), "queryParams", ScriptBytecodeAdapter.createMap(new Object[]{"rev", callSiteArray[297].callGetProperty(doc)})})));
        }
        catch (Exception e) {
            callSiteArray[298].call(Command.class, callSiteArray[299].call((Object)"Failed to remove document: ", callSiteArray[300].callGetProperty(e)));
            callSiteArray[301].call(e);
            Operation operation = (Operation)ScriptBytecodeAdapter.castToType(null, Operation.class);
            return operation;
        }
        Operation operation = (Operation)ScriptBytecodeAdapter.castToType(callSiteArray[302].call(this.objectMapper, returned, Operation.class), Operation.class);
        if (ScriptBytecodeAdapter.compareEqual(callSiteArray[303].callGroovyObjectGetProperty(operation), true)) {
            Object object = callSiteArray[304].callGroovyObjectGetProperty(operation);
            ScriptBytecodeAdapter.setProperty(object, null, doc, "_rev");
        }
        return operation;
    }

    public View getView(String document_id, String view_id, String database, Map parameters) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[305].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        document_id = ShortTypeHandling.castToString(callSiteArray[306].callSafe(document_id, "_design/", ""));
        Object returned = callSiteArray[307].callGetProperty(callSiteArray[308].call(HTTP.class, ScriptBytecodeAdapter.createPojoWrapper((String)ScriptBytecodeAdapter.asType(callSiteArray[309].call(callSiteArray[310].call(callSiteArray[311].call(callSiteArray[312].call(callSiteArray[313].call((Object)this.address, database), "/_design/"), document_id), "/_view/"), view_id), String.class), String.class), ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[314].call((Object)"AuthSession=", this.cookie)}), "queryParams", parameters})));
        View view = (View)ScriptBytecodeAdapter.castToType(callSiteArray[315].call(callSiteArray[316].callConstructor(ObjectMapper.class), returned, View.class), View.class);
        String string = database;
        ScriptBytecodeAdapter.setGroovyObjectProperty(string, CouchHandler.class, view, "database");
        View view2 = view;
        try {
            return view2;
        }
        catch (Exception e) {
            callSiteArray[317].call(Command.class, callSiteArray[318].call(callSiteArray[319].call(callSiteArray[320].call(callSiteArray[321].call(callSiteArray[322].call(callSiteArray[323].call(callSiteArray[324].call(callSiteArray[325].call((Object)"Attempted to grab: ", this.address), database), "/_design/"), document_id), "/_view/"), view_id), "?"), parameters));
            callSiteArray[326].call(Command.class, returned);
            callSiteArray[327].call(e);
            View view3 = (View)ScriptBytecodeAdapter.castToType(null, View.class);
            return view3;
        }
    }

    public View getAll(String database, Map parameters) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[328].callCurrent(this);
        } else {
            this.ensureValidSession();
        }
        Object returned = callSiteArray[329].callGetProperty(callSiteArray[330].call(HTTP.class, ScriptBytecodeAdapter.createPojoWrapper((String)ScriptBytecodeAdapter.asType(callSiteArray[331].call(callSiteArray[332].call(callSiteArray[333].call(callSiteArray[334].call((Object)this.address, database), "/_all_docs"), "?"), parameters), String.class), String.class), ScriptBytecodeAdapter.createMap(new Object[]{"headers", ScriptBytecodeAdapter.createMap(new Object[]{"Cookie", callSiteArray[335].call((Object)"AuthSession=", this.cookie)}), "queryParams", parameters})));
        View view = (View)ScriptBytecodeAdapter.castToType(callSiteArray[336].call(callSiteArray[337].callConstructor(ObjectMapper.class), returned, View.class), View.class);
        String string = database;
        ScriptBytecodeAdapter.setGroovyObjectProperty(string, CouchHandler.class, view, "database");
        View view2 = view;
        try {
            return view2;
        }
        catch (Exception e) {
            View view3 = (View)ScriptBytecodeAdapter.castToType(null, View.class);
            return view3;
        }
    }

    @Generated
    public <T> T getDoc(String id, String database, Class type) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        return this.getDoc(id, database, type, false);
    }

    @Generated
    public Operation updateDoc(Object doc) {
        Reference<Object> doc2 = new Reference<Object>(doc);
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        return this.updateDoc(doc2.get(), null);
    }

    @Generated
    public Operation removeDoc(Object doc) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        return this.removeDoc(doc, null);
    }

    @Generated
    public View getView(String document_id, String view_id, String database) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        return this.getView(document_id, view_id, database, ScriptBytecodeAdapter.createMap(new Object[0]));
    }

    @Generated
    public View getAll(String database) {
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        return this.getAll(database, ScriptBytecodeAdapter.createMap(new Object[0]));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CouchHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        CallSite[] callSiteArray = CouchHandler.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = bigDecimal = new BigDecimal("0.9");
    }

    static {
        Object object;
        CouchHandler.__$swapInit();
        cachedDocuments = object = CouchHandler.$getCallSiteArray()[338].callConstructor(ConcurrentHashMap.class);
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public void setAddress(String string) {
        this.address = string;
    }

    @Generated
    public String getCookie() {
        return this.cookie;
    }

    @Generated
    public void setCookie(String string) {
        this.cookie = string;
    }

    @Generated
    public static Object getCachedDocuments() {
        return cachedDocuments;
    }

    @Generated
    public static void setCachedDocuments(Object object) {
        cachedDocuments = object;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "configure";
        stringArray[2] = "FAIL_ON_UNKNOWN_PROPERTIES";
        stringArray[3] = "configure";
        stringArray[4] = "FAIL_ON_EMPTY_BEANS";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "addSerializer";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "registerModule";
        stringArray[9] = "normalizeAddress";
        stringArray[10] = "authenticate";
        stringArray[11] = "authenticate";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "endsWith";
        stringArray[14] = "plus";
        stringArray[15] = "startsWith";
        stringArray[16] = "toLowerCase";
        stringArray[17] = "startsWith";
        stringArray[18] = "toLowerCase";
        stringArray[19] = "plus";
        stringArray[20] = "startsWith";
        stringArray[21] = "toLowerCase";
        stringArray[22] = "startsWith";
        stringArray[23] = "toLowerCase";
        stringArray[24] = "plus";
        stringArray[25] = "authenticate";
        stringArray[26] = "username";
        stringArray[27] = "main";
        stringArray[28] = "memory cores";
        stringArray[29] = "config";
        stringArray[30] = "password";
        stringArray[31] = "main";
        stringArray[32] = "memory cores";
        stringArray[33] = "config";
        stringArray[34] = "promptInput";
        stringArray[35] = "promptInput";
        stringArray[36] = "promptPasswordInput";
        stringArray[37] = "plus";
        stringArray[38] = "plus";
        stringArray[39] = "promptPasswordInput";
        stringArray[40] = "plus";
        stringArray[41] = "plus";
        stringArray[42] = "encodePath";
        stringArray[43] = "plus";
        stringArray[44] = "post";
        stringArray[45] = "toString";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "error";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "getAt";
        stringArray[50] = "headers";
        stringArray[51] = "find";
        stringArray[52] = "getAt";
        stringArray[53] = "split";
        stringArray[54] = "getAt";
        stringArray[55] = "split";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "parseSessionExpiry";
        stringArray[58] = "debug";
        stringArray[59] = "plus";
        stringArray[60] = "plus";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "error";
        stringArray[63] = "error";
        stringArray[64] = "plus";
        stringArray[65] = "message";
        stringArray[66] = "parseLong";
        stringArray[67] = "getAt";
        stringArray[68] = "getAt";
        stringArray[69] = "plus";
        stringArray[70] = "currentTimeMillis";
        stringArray[71] = "multiply";
        stringArray[72] = "multiply";
        stringArray[73] = "plus";
        stringArray[74] = "currentTimeMillis";
        stringArray[75] = "multiply";
        stringArray[76] = "trim";
        stringArray[77] = "getAt";
        stringArray[78] = "getAt";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "ENGLISH";
        stringArray[81] = "parse";
        stringArray[82] = "minus";
        stringArray[83] = "time";
        stringArray[84] = "currentTimeMillis";
        stringArray[85] = "plus";
        stringArray[86] = "currentTimeMillis";
        stringArray[87] = "multiply";
        stringArray[88] = "debug";
        stringArray[89] = "plus";
        stringArray[90] = "currentTimeMillis";
        stringArray[91] = "multiply";
        stringArray[92] = "multiply";
        stringArray[93] = "plus";
        stringArray[94] = "currentTimeMillis";
        stringArray[95] = "debug";
        stringArray[96] = "plus";
        stringArray[97] = "plus";
        stringArray[98] = "message";
        stringArray[99] = "plus";
        stringArray[100] = "currentTimeMillis";
        stringArray[101] = "multiply";
        stringArray[102] = "multiply";
        stringArray[103] = "plus";
        stringArray[104] = "currentTimeMillis";
        stringArray[105] = "currentTimeMillis";
        stringArray[106] = "debug";
        stringArray[107] = "authenticate";
        stringArray[108] = "error";
        stringArray[109] = "ensureValidSession";
        stringArray[110] = "encodePath";
        stringArray[111] = "plus";
        stringArray[112] = "body";
        stringArray[113] = "put";
        stringArray[114] = "plus";
        stringArray[115] = "toString";
        stringArray[116] = "<$constructor$>";
        stringArray[117] = "readValue";
        stringArray[118] = "ensureValidSession";
        stringArray[119] = "encodePath";
        stringArray[120] = "plus";
        stringArray[121] = "body";
        stringArray[122] = "delete";
        stringArray[123] = "plus";
        stringArray[124] = "readValue";
        stringArray[125] = "ensureValidSession";
        stringArray[126] = "body";
        stringArray[127] = "get";
        stringArray[128] = "plus";
        stringArray[129] = "plus";
        stringArray[130] = "contains";
        stringArray[131] = "parseText";
        stringArray[132] = "<$constructor$>";
        stringArray[133] = "containsKey";
        stringArray[134] = "plus";
        stringArray[135] = "plus";
        stringArray[136] = "getClass";
        stringArray[137] = "getAt";
        stringArray[138] = "plus";
        stringArray[139] = "plus";
        stringArray[140] = "getClass";
        stringArray[141] = "getAt";
        stringArray[142] = "plus";
        stringArray[143] = "plus";
        stringArray[144] = "debug";
        stringArray[145] = "plus";
        stringArray[146] = "plus";
        stringArray[147] = "plus";
        stringArray[148] = "plus";
        stringArray[149] = "getAt";
        stringArray[150] = "plus";
        stringArray[151] = "plus";
        stringArray[152] = "containsKey";
        stringArray[153] = "plus";
        stringArray[154] = "plus";
        stringArray[155] = "getClass";
        stringArray[156] = "getAt";
        stringArray[157] = "plus";
        stringArray[158] = "plus";
        stringArray[159] = "getClass";
        stringArray[160] = "getAt";
        stringArray[161] = "plus";
        stringArray[162] = "plus";
        stringArray[163] = "debug";
        stringArray[164] = "plus";
        stringArray[165] = "plus";
        stringArray[166] = "plus";
        stringArray[167] = "plus";
        stringArray[168] = "getAt";
        stringArray[169] = "plus";
        stringArray[170] = "plus";
        stringArray[171] = "ensureValidSession";
        stringArray[172] = "body";
        stringArray[173] = "get";
        stringArray[174] = "plus";
        stringArray[175] = "plus";
        stringArray[176] = "plus";
        stringArray[177] = "plus";
        stringArray[178] = "readValue";
        stringArray[179] = "_id";
        stringArray[180] = "put";
        stringArray[181] = "plus";
        stringArray[182] = "plus";
        stringArray[183] = "debug";
        stringArray[184] = "plus";
        stringArray[185] = "plus";
        stringArray[186] = "plus";
        stringArray[187] = "plus";
        stringArray[188] = "printStackTrace";
        stringArray[189] = "ensureValidSession";
        stringArray[190] = "body";
        stringArray[191] = "get";
        stringArray[192] = "plus";
        stringArray[193] = "plus";
        stringArray[194] = "plus";
        stringArray[195] = "plus";
        stringArray[196] = "readValue";
        stringArray[197] = "_id";
        stringArray[198] = "printStackTrace";
        stringArray[199] = "ensureValidSession";
        stringArray[200] = "encodePath";
        stringArray[201] = "plus";
        stringArray[202] = "plus";
        stringArray[203] = "plus";
        stringArray[204] = "plus";
        stringArray[205] = "plus";
        stringArray[206] = "createDefault";
        stringArray[207] = "<$constructor$>";
        stringArray[208] = "setHeader";
        stringArray[209] = "plus";
        stringArray[210] = "execute";
        stringArray[211] = "getEntity";
        stringArray[212] = "value";
        stringArray[213] = "getContentType";
        stringArray[214] = "getContentLength";
        stringArray[215] = "writeTo";
        stringArray[216] = "consume";
        stringArray[217] = "printStackTrace";
        stringArray[218] = "close";
        stringArray[219] = "printStackTrace";
        stringArray[220] = "close";
        stringArray[221] = "printStackTrace";
        stringArray[222] = "ensureValidSession";
        stringArray[223] = "plus";
        stringArray[224] = "plus";
        stringArray[225] = "plus";
        stringArray[226] = "body";
        stringArray[227] = "put";
        stringArray[228] = "plus";
        stringArray[229] = "toString";
        stringArray[230] = "<$constructor$>";
        stringArray[231] = "readValue";
        stringArray[232] = "ensureValidSession";
        stringArray[233] = "database";
        stringArray[234] = "plus";
        stringArray[235] = "plus";
        stringArray[236] = "plus";
        stringArray[237] = "_id";
        stringArray[238] = "hasProperty";
        stringArray[239] = "customProperties";
        stringArray[240] = "size";
        stringArray[241] = "customProperties";
        stringArray[242] = "debug";
        stringArray[243] = "plus";
        stringArray[244] = "customProperties";
        stringArray[245] = "addAll";
        stringArray[246] = "customProperties";
        stringArray[247] = "hasProperty";
        stringArray[248] = "customProperties";
        stringArray[249] = "size";
        stringArray[250] = "customProperties";
        stringArray[251] = "debug";
        stringArray[252] = "plus";
        stringArray[253] = "customProperties";
        stringArray[254] = "addAll";
        stringArray[255] = "customProperties";
        stringArray[256] = "each";
        stringArray[257] = "each";
        stringArray[258] = "additionalProperties";
        stringArray[259] = "body";
        stringArray[260] = "put";
        stringArray[261] = "plus";
        stringArray[262] = "writeValueAsString";
        stringArray[263] = "readValue";
        stringArray[264] = "error";
        stringArray[265] = "plus";
        stringArray[266] = "message";
        stringArray[267] = "printStackTrace";
        stringArray[268] = "ensureValidSession";
        stringArray[269] = "plus";
        stringArray[270] = "plus";
        stringArray[271] = "plus";
        stringArray[272] = "plus";
        stringArray[273] = "plus";
        stringArray[274] = "body";
        stringArray[275] = "delete";
        stringArray[276] = "plus";
        stringArray[277] = "readValue";
        stringArray[278] = "error";
        stringArray[279] = "plus";
        stringArray[280] = "message";
        stringArray[281] = "printStackTrace";
        stringArray[282] = "ensureValidSession";
        stringArray[283] = "database";
        stringArray[284] = "plus";
        stringArray[285] = "plus";
        stringArray[286] = "plus";
        stringArray[287] = "_id";
        stringArray[288] = "debug";
        stringArray[289] = "plus";
        stringArray[290] = "plus";
        stringArray[291] = "plus";
        stringArray[292] = "plus";
        stringArray[293] = "_id";
        stringArray[294] = "body";
        stringArray[295] = "delete";
        stringArray[296] = "plus";
        stringArray[297] = "_rev";
        stringArray[298] = "error";
        stringArray[299] = "plus";
        stringArray[300] = "message";
        stringArray[301] = "printStackTrace";
        stringArray[302] = "readValue";
        stringArray[303] = "ok";
        stringArray[304] = "rev";
        stringArray[305] = "ensureValidSession";
        stringArray[306] = "replace";
        stringArray[307] = "body";
        stringArray[308] = "get";
        stringArray[309] = "plus";
        stringArray[310] = "plus";
        stringArray[311] = "plus";
        stringArray[312] = "plus";
        stringArray[313] = "plus";
        stringArray[314] = "plus";
        stringArray[315] = "readValue";
        stringArray[316] = "<$constructor$>";
        stringArray[317] = "error";
        stringArray[318] = "plus";
        stringArray[319] = "plus";
        stringArray[320] = "plus";
        stringArray[321] = "plus";
        stringArray[322] = "plus";
        stringArray[323] = "plus";
        stringArray[324] = "plus";
        stringArray[325] = "plus";
        stringArray[326] = "error";
        stringArray[327] = "printStackTrace";
        stringArray[328] = "ensureValidSession";
        stringArray[329] = "body";
        stringArray[330] = "get";
        stringArray[331] = "plus";
        stringArray[332] = "plus";
        stringArray[333] = "plus";
        stringArray[334] = "plus";
        stringArray[335] = "plus";
        stringArray[336] = "readValue";
        stringArray[337] = "<$constructor$>";
        stringArray[338] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[339];
        CouchHandler.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(CouchHandler.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = CouchHandler.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

