/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.internal.operation.AbstractWriteSearchIndexOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonString;

final class DropSearchIndexOperation
extends AbstractWriteSearchIndexOperation {
    private static final String COMMAND_NAME = "dropSearchIndex";
    private final String indexName;

    DropSearchIndexOperation(MongoNamespace namespace, String indexName) {
        super(namespace);
        this.indexName = indexName;
    }

    @Override
    <E extends Throwable> void swallowOrThrow(@Nullable E mongoExecutionException) throws E {
        if (mongoExecutionException != null && !CommandOperationHelper.isNamespaceError(mongoExecutionException)) {
            throw mongoExecutionException;
        }
    }

    @Override
    BsonDocument buildCommand() {
        return new BsonDocument(COMMAND_NAME, new BsonString(this.getNamespace().getCollectionName())).append("name", new BsonString(this.indexName));
    }
}

